% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/09_agg_hydroMet.R
\name{agg_hydroMet}
\alias{agg_hydroMet}
\alias{agg_hydroMet,hydroMet_BDHI-method}
\alias{agg_hydroMet,hydroMet_DGI-method}
\alias{agg_hydroMet,hydroMet_CR2-method}
\alias{agg_hydroMet,hydroMet_IANIGLA-method}
\title{Aggregate slot data}
\usage{
agg_hydroMet(
  obj,
  slot_name,
  col_name,
  fun,
  period,
  out_name = NULL,
  start_month = NULL,
  end_month = NULL,
  allow_NA = NULL
)

\S4method{agg_hydroMet}{hydroMet_BDHI}(
  obj,
  slot_name,
  col_name,
  fun,
  period,
  out_name = NULL,
  start_month = NULL,
  end_month = NULL,
  allow_NA = NULL
)

\S4method{agg_hydroMet}{hydroMet_DGI}(
  obj,
  slot_name,
  col_name,
  fun,
  period,
  out_name = NULL,
  start_month = NULL,
  end_month = NULL,
  allow_NA = NULL
)

\S4method{agg_hydroMet}{hydroMet_CR2}(
  obj,
  slot_name,
  col_name,
  fun,
  period,
  out_name = NULL,
  start_month = NULL,
  end_month = NULL,
  allow_NA = NULL
)

\S4method{agg_hydroMet}{hydroMet_IANIGLA}(
  obj,
  slot_name,
  col_name,
  fun,
  period,
  out_name = NULL,
  start_month = NULL,
  end_month = NULL,
  allow_NA = NULL
)
}
\arguments{
\item{obj}{an \code{hydroMet_XXX} class object. This method is not allowed for \code{hydroMet_compact} class. This is because this class was thought as \emph{ready to use}, so when building this class you should have already aggregated your data.}

\item{slot_name}{a single or vector string containing the slot(s) to aggregate.}

\item{col_name}{a single or vector string with the name of the column to aggregate in \code{slot_name}.}

\item{fun}{a single or vector string containing one of the following functions: \option{mean}, \option{min}, \option{max} or \option{sum}.}

\item{period}{a single or vector string with the period of aggregation: \option{hourly}, \option{daily}, \option{monthly},  \option{annual}  or \option{climatic}. \bold{NOTE_1}: the 'climatic' option returns the all series annual statistics ('fun'). \bold{NOTE_2}: if the object is of class \code{hydroMet_IANIGLA} you must provide a single \code{period} value.}

\item{out_name}{optional. Single or vector string with the output column name of the variable to aggregate.}

\item{start_month}{optional. Numeric (or numeric vector) value of the first month. It only makes sense if the \option{period} is \option{annual}. \bold{NOTE}: as an example, in case you have just two slots (out of five) that you want to aggregate annually you must provide a vector of length two. Default value is January. \bold{NOTE*}: if the object is of class \code{hydroMet_IANIGLA} you must provide a single \code{start_month} value.}

\item{end_month}{optional. Numeric (or numeric vector) value of the last month. It only makes sense if the \option{period} is \option{annual}. \bold{NOTE}: as an example, in case you have just two slots (out of five) that you want to aggregate annually you must provide a vector of length two. Default value es December. \bold{NOTE*}: if the object is of class \code{hydroMet_IANIGLA} you must provide a single \code{end_month} value.}

\item{allow_NA}{optional. Numeric (or numeric vector) value with the maximum allowed number of \code{NA_real_} values.  By default the function will not tolerate any \code{NA_real_} in an aggregation period (and will return \code{NA_real_} instead).}
}
\value{
An \code{hydroMet_XXX} class object with the required slot(s) aggregated.
}
\description{
This method provides common functions to aggregate the data inside a slot.
}
\section{Functions}{
\itemize{
\item \code{agg_hydroMet,hydroMet_BDHI-method}: aggregation method for BDHI data

\item \code{agg_hydroMet,hydroMet_DGI-method}: aggregation method for DGI data

\item \code{agg_hydroMet,hydroMet_CR2-method}: aggregation method for CR2 data

\item \code{agg_hydroMet,hydroMet_IANIGLA-method}: aggregation method for IANIGLA data
}}

\examples{
# Create BDHI hydro-met station
guido <- create_hydroMet(class_name = 'BDHI')

# List with meteorological variables (slots in BDHI's object)
cargar <- list('precip', 'Qmd', 'Qmm')

# Assign as names the files
hydro_files   <- list.files( system.file('extdata', package = "hydroToolkit"), pattern = 'Guido' )
names(cargar) <- hydro_files

# Build the object with the met records
guido <- build_hydroMet(obj = guido, slot_list = cargar, 
               path = system.file('extdata', package = "hydroToolkit") )

# Aggregrate precipitation serie
guido <- agg_hydroMet(obj = guido, slot_name = 'precip', col_name = 'precip', fun = 'sum',
       period = 'monthly', out_name = 'P_month', allow_NA = 3)
               
}
