% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydrogeo.R
\docType{package}
\name{hydrogeo}
\alias{hydrogeo}
\alias{hydrogeo-package}
\title{Groundwater data presentation and interpretation.}
\description{
Contains one function, for drawing Piper (or Piper-Hill) diagrams
from water analyses for major ions, and a dataset from Zaporozec
}
\details{
\tabular{ll}{
Package: \tab hydrogeo\cr
Type: \tab Package\cr
Version: \tab 0.5-1\cr
Date: \tab 2016-11-17\cr
License: \tab BSD\cr
LazyLoad: \tab yes\cr
}
}
\examples{
library(hydrogeo)
data(zaporozec)
zaporozec$CO3 <- rep(0,9) # toPercent expects CO3
zaporozec$Na <- rep(0,9)  # toPercent expects Na
z <- toPercent(zaporozec)
pz <- piper(z)
plot(pz,cex=1.5)
}
\seealso{
\code{\link{piper}} and \code{\link{toPercent}} \code{\link{zaporozec}}
}
\author{
Myles English \email{myles@rockhead.biz}
}
\keyword{groundwater}
\keyword{hydrogeology}
\keyword{hydrology}
\keyword{package}
\keyword{water}
