% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesize.R
\name{z_test}
\alias{z_test}
\title{One-Sample Z-Test}
\usage{
z_test(x, mu0 = 0, sigma, alternative = c("two.sided", "less", "greater"))
}
\arguments{
\item{x}{Numeric vector. The sample data.}

\item{mu0}{Numeric. The hypothesized population mean under \eqn{H_0}.
Default is 0.}

\item{sigma}{Numeric. The known population standard deviation.}

\item{alternative}{Character. Type of alternative hypothesis:
\code{"two.sided"} (default), \code{"less"}, or \code{"greater"}.}
}
\value{
A \code{hypothesis_test} object of subclass \code{z_test} containing:
\describe{
\item{stat}{The z-statistic}
\item{p.value}{The p-value for the specified alternative}
\item{dof}{Degrees of freedom (Inf for normal distribution)}
\item{alternative}{The alternative hypothesis used}
\item{null_value}{The hypothesized mean \eqn{\mu_0}}
\item{estimate}{The sample mean \eqn{\bar{x}}}
\item{sigma}{The known population standard deviation}
\item{n}{The sample size}
}
}
\description{
Tests whether a population mean equals a hypothesized value when the
population standard deviation is known.
}
\details{
The z-test is one of the simplest and most fundamental hypothesis tests.
It tests \eqn{H_0: \mu = \mu_0} against various alternatives when the
population standard deviation \eqn{\sigma} is known.

Given a sample \eqn{x_1, \ldots, x_n}, the test statistic is:

\deqn{z = \frac{\bar{x} - \mu_0}{\sigma / \sqrt{n}}}

Under \eqn{H_0}, this follows a standard normal distribution. The p-value
depends on the alternative hypothesis:
\itemize{
\item Two-sided (\eqn{H_1: \mu \neq \mu_0}): \eqn{2 \cdot P(Z > |z|)}
\item Less (\eqn{H_1: \mu < \mu_0}): \eqn{P(Z < z)}
\item Greater (\eqn{H_1: \mu > \mu_0}): \eqn{P(Z > z)}
}
}
\section{When to Use}{

The z-test requires knowing the population standard deviation, which is
rare in practice. When \eqn{\sigma} is unknown and estimated from data,
use a t-test instead. The z-test is primarily pedagogical, illustrating
the logic of hypothesis testing in its simplest form.
}

\section{Relationship to Wald Test}{

The z-test is a special case of the Wald test (\code{\link[=wald_test]{wald_test()}}) where the
parameter is a mean and the standard error is \eqn{\sigma/\sqrt{n}}.
The Wald test generalizes this to any asymptotically normal estimator.
}

\examples{
# A light bulb manufacturer claims bulbs last 1000 hours on average.
# We test 50 bulbs and know from historical data that sigma = 100 hours.
lifetimes <- c(980, 1020, 950, 1010, 990, 1005, 970, 1030, 985, 995,
               1000, 1015, 960, 1025, 975, 1008, 992, 1012, 988, 1002,
               978, 1018, 965, 1022, 982, 1005, 995, 1010, 972, 1028,
               990, 1000, 985, 1015, 968, 1020, 980, 1008, 992, 1012,
               975, 1018, 962, 1025, 985, 1002, 988, 1010, 978, 1020)

# Two-sided test: H0: mu = 1000 vs H1: mu != 1000
z_test(lifetimes, mu0 = 1000, sigma = 100)

# One-sided test: are bulbs lasting less than claimed?
z_test(lifetimes, mu0 = 1000, sigma = 100, alternative = "less")

}
\seealso{
\code{\link[=wald_test]{wald_test()}} for the general case with estimated standard errors
}
