% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MR_het_test.R
\name{MR_het_test}
\alias{MR_het_test}
\title{Test of Heterogeneity in MR using Principal Components}
\usage{
MR_het_test(x.b, y.b, x.se, y.se, b0, k = NULL, cum.prop = 0.8)
}
\arguments{
\item{x.b}{a vector of the estimated regression coefficients from the SNP-exposure GWAS}

\item{y.b}{a vector of the estimated regression coefficients from the SNP-outcome GWAS}

\item{x.se}{a vector of SEs for \code{x.b}}

\item{y.se}{a vector of SEs for \code{y.b}}

\item{b0}{a value used for the common effect size. It is used for the weighting matrix}

\item{k}{the number of principal components used. It is used by the \eqn{\tilde Q(b_0)} statistic. The default is NULL}

\item{cum.prop}{threshold for selecting \code{k}. It is void if \code{k} is specified. The default is 0.8, i.e., the proportion of variance explained by the top \code{k} principal components is 0.8}
}
\value{
A list containing the following components:

* \eqn{P_\text{min}(b_0)} statistic and its \eqn{P}-value.

* \eqn{\tilde Q_\text{min}(b_0)} statistic, its degrees of freedom, and its \eqn{P}-value.
}
\description{
\code{MR_het_test} performs tests of heterogeneity in MR. 
  
%% ~~ If necessary, more details than the description above ~~
}
\examples{
p = 10
b = 0.5
gamma.true = runif(p, 0.34, 1.1)
x.se = runif(p, 0.06, 0.1)
y.se = runif(p, 0.015, 0.11)
x.b = rnorm(p, gamma.true, x.se)
y.b = rnorm(p, b*gamma.true, y.se)
b0 = 0.4

MR_het_test(x.b, y.b, x.se, y.se, b0)

}
\references{
Wang, K, Alberding, Steven Y. (2024) Powerful test of heterogeneity in two-sample summary-data Mendelian randomization. Submitted.
}
\author{
Kai Wang \code{<kai-wang@uiowa.edu>}
}
