% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdn.R
\name{mdn}
\alias{mdn}
\title{Mediation Analysis via Likelihood}
\usage{
mdn(fit.M, fit.Y, X, sig.level = 0.05, B = 0)
}
\arguments{
\item{fit.M}{a fitted model object for mediator. It is an object from which
the function \code{logLik} can extract the log-likelihood. Examples include
those from ``\code{lm}'', ``\code{glm}'', etc.}

\item{fit.Y}{a fitted model object for outcome. It can be of a class
different from the model for the mediator}

\item{X}{a character string of the name of the treatment variable.}

\item{sig.level}{a numerical variable specifying the significance level for
the test of the mediated effect.}

\item{B}{an integer specifying the number of replicates used in the
bootstrapping method for the confidence interval. Default value is 0 and 
bootstrapping is not conducted}
}
\value{
A list with class ``\code{mdn}'' containing the following
components: \item{result}{a data frame containing the results of the
mediation analysis. The are five variables. They include estimates of
various effects and lower and upper bounds of the boostrap confidence
interval at level (1-\code{sig.level}) followed by test statistics and their
respective p-values.  } \item{test}{a character string specifying the test
statistic used for the mediated effect } \item{Test}{a numerical value of 0 or 1. 
If the specified test statistic is significant, its value is 1; otherwise its value is 0 } \item{sig.level }{ a numerical
variable specifying the significance level for the test of the mediated
effect. } \item{Sample.size }{ number of subjects in the data } \item{B }{
an integer specifying the number of replicates used for the bootstrapping }
}
\description{
\code{mdn} conducts mediation analysis in terms of likelihood.
}
\details{
%% ~~ If necessary, more details than the description above ~~ 
Necessary log-likelihoods are extracted from the two fitted models. Various effects
are then calculated. Significance of the mediated effect is known up to
whether it is larger or smaller than \code{sig.level}. If it is larger, a 1
is reported; otherwise a 0 is reported. There is no p-value.
}
\examples{
data("jobs", package = "mediation")

fit.M <- lm(job_seek ~ treat + econ_hard + sex + age, data=jobs)
fit.Y <- lm(depress2 ~ treat + job_seek + econ_hard + sex + age, data=jobs)
mdn(fit.M, fit.Y, "treat")
mdn(fit.M, fit.Y, "treat", B=100)
}
\references{
Berger, R.L. (1997) Likelihood ratio tests and
intersection-union tests. Advances in statistical decision theory and
applications. Birkh\"auser Boston, 225-237.

Wang, K. (2019) Likelihood-based analysis of the statistical effects of a treatment on an outcome. Submitted.
}
\author{
Kai Wang \code{<kai-wang@uiowa.edu>}
}
\keyword{mediation}
