## ----global-options, include=FALSE--------------------------------------------------------------------------------------------------------------------------------------------------------------------
if (requireNamespace("knitr", quietly = TRUE)) {
  kc <- get("opts_chunk", envir = asNamespace("knitr"))
  kc$set(
    collapse   = TRUE,
    comment    = "#>",
    fig.retina = 2,
    fig.align  = "center",
    fig.width  = 6,
    fig.height = 3,
    warning    = FALSE,
    message    = FALSE
  )
} else {
  warning("Package 'knitr' not available; vignette chunk options not set.")
}
old_options <- options(width = 200, digits = 3)

paste0 <- base::paste0
paste  <- base::paste


## ----eval = TRUE, echo = FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(iSTAY)

## ----eval = FALSE, echo = TRUE------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# ## install iSTAY package from CRAN
# # install.packages("iSTAY")
# 
# ## install the latest version from github
# install.packages('devtools')
# library(devtools)
# install_github("AnneChao/iSTAY")
# 
# ## import packages
# library(iSTAY)

## ----eval=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# iSTAY_Single(data, order.q = c(1, 2), Alltime = TRUE, start_T = NULL, end_T = NULL)

## ----eval=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# iSTAY_Multiple(data, order.q = c(1, 2), Alltime = TRUE, start_T = NULL, end_T = NULL)

## ----eval=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# iSTAY_Hier(data, structure, order.q = c(1, 2), Alltime = TRUE, start_T = NULL, end_T = NULL)

## ----eval=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# ggiSTAY_qprofile(output)

## ----eval=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# ggiSTAY_analysis(output, x_variable, by_group = NULL, model = "LMM")

## ----eval=F-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# data("Data_Jena_20_metacommunities")
# metacommunities <- Data_Jena_20_metacommunities
# head(round(metacommunities[[1]][,1:5],2), 10)

## ----echo=F-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
data("Data_Jena_20_metacommunities")
metacommunities <- Data_Jena_20_metacommunities
head(round(metacommunities[[1]][,1:5],2), 10)

## ----eval=F-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# data("Data_Jena_20_metacommunities")
# individual_plots <- do.call(rbind, Data_Jena_20_metacommunities)
# head(round(individual_plots[,1:5],2), 10)

## ----echo=F-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
data("Data_Jena_20_metacommunities")
individual_plots <- do.call(rbind, Data_Jena_20_metacommunities)
head(round(individual_plots[,1:5],2), 10)

## ----eval=F-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# data("Data_Jena_76_metapopulations")
# metapopulations <- Data_Jena_76_metapopulations
# head(round(metapopulations[[1]][,1:5],2), 10)

## ----echo=F-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
data("Data_Jena_76_metapopulations")
metapopulations <- Data_Jena_76_metapopulations
head(round(metapopulations[[1]][,1:5],2), 10)

## ----eval=F-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# data("Data_Jena_76_metapopulations")
# individual_populations <- do.call(rbind, Data_Jena_76_metapopulations)
# head(round(individual_populations[,1:5],2), 10)

## ----echo=F-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
data("Data_Jena_76_metapopulations")
individual_populations <- do.call(rbind, Data_Jena_76_metapopulations)
head(round(individual_populations[,1:5],2), 10)

## ----eval=F-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# data("Data_Jena_462_populations")
# head(round(Data_Jena_462_populations[,1:5],2), 10)

## ----echo=F-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
data("Data_Jena_462_populations")
head(round(Data_Jena_462_populations[,1:5],2), 10)

## ----eval=F-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# data("Data_Jena_hierarchical_structure")
# head(Data_Jena_hierarchical_structure, 10)

## ----echo=F-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
data("Data_Jena_hierarchical_structure")
head(Data_Jena_hierarchical_structure, 10)

## ----eval=F-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# individual_plots <- do.call(rbind, Data_Jena_20_metacommunities)
# output_two_plots_q <- iSTAY_Single(data = individual_plots[which(rownames(individual_plots) %in% c("B1_4.B1A04", "B4_2.B4A14")),],
#                                order.q=seq(0.1,2,0.1),
#                                Alltime = TRUE)
# head(output_two_plots_q, 10)

## ----echo=F-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
individual_plots <- do.call(rbind, Data_Jena_20_metacommunities)
output_two_plots_q <- iSTAY_Single(data = individual_plots[which(rownames(individual_plots) %in% c("B1_4.B1A04", "B4_2.B4A14")),],
                               order.q=seq(0.1,2,0.1), 
                               Alltime = TRUE)

head(cbind(output_two_plots_q[,1:2],"Stability"=round(output_two_plots_q[,3],3)), 10)


## ----fig.align='center'-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
ggiSTAY_qprofile(output = output_two_plots_q)

## ----eval=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# output_individual_plots_div <- iSTAY_Single(data = individual_plots, order.q = c(1,2), Alltime = TRUE)
# output_individual_plots_div <- data.frame(output_individual_plots_div,
#                                 log2_sowndiv = log2(as.numeric(do.call(rbind,
#                                                    strsplit(output_individual_plots_div[,1],"[._]+"))[,2])),
#                                 block=do.call(rbind, strsplit(output_individual_plots_div[,1],"[._]+"))[,1])
# colnames(output_individual_plots_div)[1] <- c("Dataset")
# head(output_individual_plots_div, 10)

## ----echo=FALSE, digits=3-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------
output_individual_plots_div <- iSTAY_Single(data = individual_plots, order.q = c(1,2), Alltime = TRUE)
output_individual_plots_div <- data.frame(output_individual_plots_div,
                                log2_sowndiv = log2(as.numeric(do.call(rbind,
                                                   strsplit(output_individual_plots_div[,1],"[._]+"))[,2])),
                                block=do.call(rbind, strsplit(output_individual_plots_div[,1],"[._]+"))[,1])
colnames(output_individual_plots_div)[1] <- c("Dataset")
head(cbind(output_individual_plots_div[,1:2],"Stability"=round(output_individual_plots_div[,3],3),output_individual_plots_div[,4:5]), 10)


## ----fig.width = 7------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
ggiSTAY_analysis(output = output_individual_plots_div, x_variable = "log2_sowndiv", 
                by_group = "block", model = "LMM")

## ----eval=F-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# individual_populations <- do.call(rbind, Data_Jena_76_metapopulations)
# output_two_populations_q <- iSTAY_Single(data = individual_populations[which(rownames(individual_populations) %in% c("B1A06_B1_16.BM_Ant.odo", "B1A06_B1_16.BM_Cam.pat")),],
#                                        order.q=seq(0.1,2,0.1), Alltime=TRUE)
# head(output_two_populations_q, 10)

## ----echo=F-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
individual_populations <- do.call(rbind, Data_Jena_76_metapopulations)
output_two_populations_q <- iSTAY_Single(data = individual_populations[which(rownames(individual_populations) %in% c("B1A06_B1_16.BM_Ant.odo", "B1A06_B1_16.BM_Cam.pat")),],
                                       order.q=seq(0.1,2,0.1), Alltime=TRUE)

head(cbind(output_two_populations_q[,1:2],"Stability"=round(output_two_populations_q[,3],3)), 10)

## ----fig.align='center'-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
ggiSTAY_qprofile(output = output_two_populations_q)

## ----eval=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# output_individual_populations_div <- iSTAY_Single(data = individual_populations,
#                                          order.q = c(1,2), Alltime=TRUE)
# output_individual_populations_div <- data.frame(output_individual_populations_div,
#                               log2_sowndiv = log2(as.numeric(do.call(rbind,
#                                       strsplit(output_individual_populations_div[,1],"[._]+"))[,3])),
#                               block = do.call(rbind,
#                                     strsplit(output_individual_populations_div[,1],"[._]+"))[,2])
# head(output_individual_populations_div, 10)

## ----echo=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
output_individual_populations_div <- iSTAY_Single(data = individual_populations,
                                         order.q = c(1,2), Alltime=TRUE)
output_individual_populations_div <- data.frame(output_individual_populations_div,
                              log2_sowndiv = log2(as.numeric(do.call(rbind,
                                      strsplit(output_individual_populations_div[,1],"[._]+"))[,3])),
                              block = do.call(rbind,
                                    strsplit(output_individual_populations_div[,1],"[._]+"))[,2])

head(cbind(output_individual_populations_div[,1:2],"Stability"=round(output_individual_populations_div[,3],3),output_individual_populations_div[,4:5]), 10)


## ----fig.width = 7------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
ggiSTAY_analysis(output=output_individual_populations_div, x_variable="log2_sowndiv",
                    by_group="block", model="LMM")

## ----eval=F-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# metacommunities <- Data_Jena_20_metacommunities
# output_two_metacommunities_q <- iSTAY_Multiple(data = metacommunities[which(names(metacommunities) %in% c("B1_1",  "B3_2"))],
#                                 order.q = seq(0.1,2,0.1), Alltime=TRUE)
# head(output_two_metacommunities_q, 10)

## ----echo=F-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
metacommunities <- Data_Jena_20_metacommunities
output_two_metacommunities_q <- iSTAY_Multiple(data = metacommunities[which(names(metacommunities) %in% c("B1_1",  "B3_2"))],
                                order.q = seq(0.1,2,0.1), Alltime=TRUE)
head(output_two_metacommunities_q, 10)

## ----fig.align='center', fig.width = 7, fig.height = 4.5----------------------------------------------------------------------------------------------------------------------------------------------
ggiSTAY_qprofile(output = output_two_metacommunities_q)

## ----eval=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# output_metacommunities_div <- iSTAY_Multiple(data = metacommunities, order.q=c(1,2), Alltime=TRUE)
# 
# output_metacommunities_div <- data.frame(output_multi_div,
#                                log2_sowndiv = log2(as.numeric(do.call(rbind, strsplit(output_metacommunities_div[, 1], "_"))[, 2])),
#          block = do.call(rbind, strsplit(output_metacommunities_div[, 1], "_"))[, 1])
# rownames(output_metacommunities_div) <- NULL
# head(cbind(output_metacommunities_div[,1:2], round(output_metacommunities_div[3:6],3), output_metacommunities_div[,7:8]), 10)

## ----echo=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
output_metacommunities_div <- iSTAY_Multiple(data = metacommunities, order.q = c(1,2), Alltime = TRUE)

output_metacommunities_div <- data.frame(output_metacommunities_div,
                               log2_sowndiv = log2(as.numeric(do.call(rbind, strsplit(output_metacommunities_div[, 1], "_"))[, 2])),
         block = do.call(rbind, strsplit(output_metacommunities_div[, 1], "_"))[, 1])
rownames(output_metacommunities_div) <- NULL
head(cbind(output_metacommunities_div[,1:2], round(output_metacommunities_div[3:6],3), output_metacommunities_div[,7:8]), 10)

## ----fig.width = 8, fig.height=9.5--------------------------------------------------------------------------------------------------------------------------------------------------------------------
ggiSTAY_analysis(output = output_metacommunities_div, x_variable = "log2_sowndiv", 
                    by_group = "block", model = "LMM")

## ----eval=F-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# metapopulations <- Data_Jena_76_metapopulations
# output_two_metapopulations_q <- iSTAY_Multiple(data = metapopulations[which(names(metapopulations) %in% c("B1A04_B1_4", "B4A14_B4_2"))],
#                                             order.q = seq(0.1,2,0.1), Alltime = TRUE)
# head(output_two_metapopulations_q, 10)

## ----echo=F-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
metapopulations <- Data_Jena_76_metapopulations
output_two_metapopulations_q <- iSTAY_Multiple(data = metapopulations[which(names(metapopulations) %in% c("B1A04_B1_4", "B4A14_B4_2"))],
                                            order.q = seq(0.1,2,0.1), Alltime = TRUE)
head(output_two_metapopulations_q, 10)

## ----fig.align='center', fig.width = 7, fig.height = 4.5----------------------------------------------------------------------------------------------------------------------------------------------
ggiSTAY_qprofile(output = output_two_metapopulations_q)

## ----eval=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# output_metapopulations_div <- iSTAY_Multiple(data = metapopulations,
#                                           order.q = c(1,2), Alltime = TRUE)
# output_metapopulations_div <- data.frame(output_metapopulations_div,
#                              log2_sowndiv = log2(as.numeric(do.call(rbind,
#                                       strsplit(output_metapopulations_div[,1],"[._]+"))[,3])),
#                              block = do.call(rbind,
#                                    strsplit(output_metapopulations_div[,1],"_"))[,2])
# head(output_metapopulations_div, 10)

## ----echo=FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
output_metapopulations_div <- iSTAY_Multiple(data = metapopulations,
                                          order.q = c(1,2), Alltime = TRUE)
output_metapopulations_div <- data.frame(output_metapopulations_div,
                             log2_sowndiv = log2(as.numeric(do.call(rbind,
                                      strsplit(output_metapopulations_div[,1],"[._]+"))[,3])),
                             block = do.call(rbind,
                                   strsplit(output_metapopulations_div[,1],"_"))[,2])
head(output_metapopulations_div, 10)


## ----fig.width = 8, fig.height=9.5--------------------------------------------------------------------------------------------------------------------------------------------------------------------
ggiSTAY_analysis(output=output_metapopulations_div, x_variable="log2_sowndiv",
                    by_group="block", model="LMM")

## ----eval=F-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# data("Data_Jena_462_populations")
# data("Data_Jena_hierarchical_structure")
# output_hier_q <- iSTAY_Hier(data = Data_Jena_462_populations,
#                             structure = Data_Jena_hierarchical_structure,
#                            order.q=seq(0.1,2,0.1), Alltime=TRUE)
# head(cbind(output_hier_q[,1:2], round(output_hier_q[,3:6],3)), 10)

## ----echo=F-------------------------------------------------------------------

data("Data_Jena_462_populations")
data("Data_Jena_hierarchical_structure")
output_hier_q <- iSTAY_Hier(data = Data_Jena_462_populations,
                            structure = Data_Jena_hierarchical_structure,
                           order.q=seq(0.1,2,0.1), Alltime=TRUE)
head(cbind(output_hier_q[,1:2], round(output_hier_q[,3:6],3)), 10)
on.exit(options(old_options)) # Restore user options to comply with CRAN policy


## ----fig.align='left', fig.width = 5, fig.height = 3--------------------------
hierplot <- ggiSTAY_qprofile(output=output_hier_q)
hierplot[[1]]

## ----fig.align='left', fig.width = 9.5, fig.height = 3------------------------
hierplot[[2]]

