% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getData.R
\name{getTraitsData}
\alias{getTraitsData}
\title{Getting Trait Values of Accessions for a Specific Trait}
\usage{
getTraitsData(IG, traitID)
}
\arguments{
\item{IG}{factor. Unique identifier of accession.}

\item{traitID}{integer. Unique identifier of trait (from \code{\link[icardaFIGSr]{getTraits}}).}
}
\value{
A data frame with scores for the trait specified in \code{traitID} for the accessions given in \code{IG}.
}
\description{
Return a data frame with observed values of accessions for associated Trait
}
\details{
Possible inputs for \code{traitID} can be found using the \code{\link[icardaFIGSr]{getTraits}} function (see section 'Examples').
}
\examples{
if(interactive()){
 # Check trait ID for septoria and get septoria data for durum wheat
 durum <- getAccessions(crop = 'Durum wheat', coor = TRUE)
 durumTraits <- getTraits(crop = 'Durum wheat')
 septoria <- getTraitsData(IG = durum$IG, traitID = 145)
}
}
\author{
Khadija Aouzal, Amal Ibnelhobyb, Zakaria Kehel, Fawzy Nawar
}
