#' Survival Times of 33 Leukemia Patients
#'
#' This data set is taken from Ibrahim, Joseph G. (1990). \emph{Incomplete Data in Generalized Linear Models}. Journal of the American Statistical Association, Vol.85, No. 411, pp. 765 - 769. The original source is Feigl, P., and Zelen, M. (1965), \emph{Estimation of Exponential Survival Probabilities With Concomitant Information}, Biometrics, 21, pp. 826-838.
#'
#' @name Leukemia.data
#' @docType data
#' @usage data(Leukemia.data)
#' @format A data frame with 33 observations on the following 3 variables.
#'  \describe{
#'    \item{\code{x1}}{a numeric vector (covariate)}
#'    \item{\code{x2}}{a numeric vector (covariate)}
#'    \item{\code{y}}{a numeric vector (the dependent variable)}
#'  }
#' @source Feigl, P., and Zelen, M. (1965), \emph{Estimation of Exponential Survival Probabilities With Concomitant Information}, Biometrics, 21, pp. 826-838.
#'         Ibrahim, Joseph G. (1990). \emph{Incomplete Data in Generalized Linear Models}. Journal of the American Statistical Association, Vol.85, No. 411, pp. 765 - 769.
NULL

#' TLI Study of 82 Patients
#'
#' This data set is taken from Ibrahim, Joseph G. (1990). \emph{Incomplete Data in Generalized Linear Models}. Journal of the American Statistical Association, Vol.85, No. 411, pp. 765 - 769. The original source is Colice, G. L., Stukel, T. A., and Dain, B. (1989), \emph{Laryngeal Complications of Prolonged Intubation}, Chest, No. 96, pp. 877-884.
#'
#' @name TLI.data
#' @docType data
#' @usage data(TLI.data)
#' @format A data frame with 82 observations on the following 4 variables (3 independent variables and 1 dependent variable).
#'  \describe{
#'  \item{\code{x1}}{a numeric vector}
#'  \item{\code{x2}}{a numeric vector}
#'  \item{\code{x3}}{a numeric vector}
#'  \item{\code{y}}{a numeric vector (the dependent variable)}
#'  }
#' @source Colice, G. L., Stukel, T. A., and Dain, B. (1989), \emph{Laryngeal Complications of Prolonged Intubation}, Chest, No. 96, pp. 877-884.
#'         Ibrahim, Joseph G. (1990). \emph{Incomplete Data in Generalized Linear Models}. Journal of the American Statistical Association, Vol.85,
NULL
