% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icd10_to_comorbid.R
\name{icd10_to_comorbid}
\alias{icd10_to_comorbid}
\title{Find Comorbidities from ICD_10 Codes}
\usage{
icd10_to_comorbid(df, idx, icd_cols, mapping, batch_size = 1000)
}
\arguments{
\item{df}{The dataframe containing the data.}

\item{idx}{The name of the column representing the patient identifiers.}

\item{icd_cols}{A character vector of the columns containing ICD codes.}

\item{mapping}{The mapping of comorbidities to ICD codes (e.g., quan_elixhauser10, charlson10, custom list).}

\item{batch_size}{An optional integer specifying the number of rows to process per batch. Default is 1000.}
}
\value{
A dataframe with comorbidities as columns and IDs as rows, with True or False values indicating
  whether each comorbidity is present for each ID.
}
\description{
This function maps ICD_10 codes to comorbidities based on a provided mapping in order to
indicate whether each comorbidity is present for each ID.
}
\details{
This function assumes that the input dataframe is in wide format, where each row represents
  a unique identifier (ID), and each column contains a variable associated with that ID. The function
  maps the ICD_10 codes in the specified columns to comorbidities based on the provided mapping.

 The mapping can be one of the following:

- Pre-defined mappings such as "quan_elixhauser10" or "charlson10", which are based on established comorbidity indices.

 - Custom mappings (list), where each key represents a comorbidity and its value is a vector of ICD-9 codes associated with that comorbidity.
  The custom mapping codes may include up to 2 decimal places.
}
\examples{
df <- data.frame(ID = c(1, 2, 3),
                 icd_1 = c("I21.0", "I50.3", "J45.1"),
                 icd_2 = c("I63.38", "I10.2", "I25.2"))
# Using pre-existing mapping (e.g., charlson10 or quan_elixhauser10)
mapping <- "charlson10"
icd10_to_comorbid(df, "ID", c("icd_1", "icd_2"), mapping)

# Using custom mapping
custom_mapping <- list("Myocardial Infarction" = c("I21.x", "I22.x", "I25.2"),
                       "Congestive Heart Failure" = c("I43.x", "I50.x", "I09.9"))
icd10_to_comorbid(df, "ID", c("icd_1", "icd_2"), custom_mapping, batch_size = 2)

}
\references{
1. Quan, H., Sundararajan, V., Halfon, P., Fong, A., Burnand, B., Luthi, J. C., ... & Ghali, W. A. (2005).
  Coding algorithms for defining comorbidities in ICD-9-CM and ICD-10 administrative data.
  Medical care, 43(11), 1130-1139.
2. ICD: Python library for working with International Classification of Diseases (ICD) codes.
   Available online: https://github.com/mark-hoffmann/icd
}
