% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFishStockReferencePoints.R
\name{getFishStockReferencePoints}
\alias{getFishStockReferencePoints}
\title{Get Reference Points}
\usage{
getFishStockReferencePoints(assessmentKey, ...)
}
\arguments{
\item{assessmentKey}{the unique identifier of the stock assessment}

\item{...}{arguments passed to \code{\link{sag_get}}.}
}
\value{
A data frame.
}
\description{
Get biological reference points for all stocks in a given assessment year.
}
\examples{
\dontrun{
assessmentKey <- findAssessmentKey("cod.27.21", year = 2023)
refpts <- getFishStockReferencePoints(assessmentKey)
refpts

# To get all reference points in a given assessment year:
keys2022 <- findAssessmentKey(year = 2022, full = TRUE)
keys2022 <- keys2022[keys2022$Purpose == "Advice",]
refpts2022 <- getFishStockReferencePoints(keys2022$AssessmentKey)
refpts2022
}
}
\seealso{
\code{\link{getSAG}} supports querying many years and quarters in one
  function call.

\code{\link{getListStocks}} and \code{\link{getSummaryTable}} get a list of
  stocks and summary results.

\code{\link{icesSAG-package}} gives an overview of the package.
}
\author{
Colin Millar.
}
