% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sag_get.R
\name{sag_get}
\alias{sag_get}
\alias{sag_get_cached}
\title{Get a url}
\usage{
sag_get(
  url,
  retry = TRUE,
  quiet = !getOption("icesSAG.messages"),
  verbose = FALSE,
  content = TRUE,
  use_token = getOption("icesSAG.use_token")
)

sag_get_cached(
  url,
  retry = TRUE,
  quiet = !getOption("icesSAG.messages"),
  verbose = FALSE,
  content = TRUE,
  use_token = getOption("icesSAG.use_token")
)
}
\arguments{
\item{url}{the url to get.}

\item{retry}{should the get request be retried if first attempt
fails? default TRUE.}

\item{quiet}{should all messages be suppressed, default FALSE.}

\item{verbose}{should verbose output form the http request be
returned? default FALSE.}

\item{content}{should content be returned, or the full http response?
default TRUE, i.e. content is returned by default.}

\item{use_token}{should an authentication token be sent with the
request? default is the value of the option icesSAG.use_token.}
}
\value{
content or an http response.
}
\description{
Get a url, optionally using an ICES authentication token
}
\section{Functions}{
\itemize{
\item \code{sag_get_cached()}: cached version of sag_get

}}
\examples{
\dontrun{
sag_get(sag_api("StockList", year = 2022))
}
}
\seealso{
\code{\link{sag_api}} builds a SAG web service url.

\code{\link{icesSAG-package}} gives an overview of the package.
}
