% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iclogcondist_simulation_dist.R
\name{ptlnorm}
\alias{ptlnorm}
\title{Cumulative Distribution Function of a Truncated Log-Normal Distribution}
\usage{
ptlnorm(x, meanlog = 0, sdlog = 1, upper_bound = Inf)
}
\arguments{
\item{x}{A numeric vector at which to evaluate the CDF.}

\item{meanlog}{A numeric value representing the mean of the log-normal distribution on the log scale. Default is \code{0}.}

\item{sdlog}{A positive numeric value representing the standard deviation of the log-normal distribution on the log scale. Default is \code{1}.}

\item{upper_bound}{A positive numeric value indicating the upper truncation point. Default is \code{Inf} (no truncation).}
}
\value{
A numeric vector of the CDF values of the truncated log-normal distribution at \code{x}.
}
\description{
This function computes the cumulative distribution function (CDF) of a truncated log-normal distribution
at a given point \code{x}.
}
\examples{
# Evaluate the CDF at x = 2 for a truncated log-normal distribution
ptlnorm(2, meanlog = 0, sdlog = 1, upper_bound = 5)

}
