% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iclogcondist_simulation_dist.R
\name{qtweibull}
\alias{qtweibull}
\title{Quantile Function of a Truncated Weibull Distribution}
\usage{
qtweibull(q, shape = 1, scale = 1, upper_bound = Inf)
}
\arguments{
\item{q}{A numeric vector of probabilities for which to calculate the quantiles.}

\item{shape}{A positive numeric value representing the shape parameter of the Weibull distribution. Default is \code{1}.}

\item{scale}{A positive numeric value representing the scale parameter of the Weibull distribution. Default is \code{1}.}

\item{upper_bound}{A positive numeric value indicating the upper truncation point. Default is \code{Inf} (no truncation).}
}
\value{
A numeric vector of quantiles corresponding to the given probabilities in \code{q}.
}
\description{
This function computes the quantiles of a truncated Weibull distribution for a given probability vector.
}
\examples{
# Calculate the 0.5 quantile of a truncated Weibull distribution
qtweibull(0.5, shape = 2, scale = 1, upper_bound = 5)

}
