% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-spherical.R, R/grid-move.R
\docType{data}
\name{rotate,matrix-method}
\alias{rotate,matrix-method}
\alias{rotate,data.frame-method}
\alias{rotate}
\alias{rotate,trigrid-method}
\title{Rotation of 3d objects}
\format{
An object of class \code{standardGeneric} of length 1.
}
\usage{
\S4method{rotate}{matrix}(
  x,
  angles = "random",
  long = 0,
  lat = 0,
  reflong = NULL,
  pivot = c(0, 0, 0),
  radius = authRadius,
  output = "polar"
)

\S4method{rotate}{data.frame}(x, coords = NULL, ...)

rotate

\S4method{rotate}{trigrid}(x, angles = "random", pivot = NA, projnote = TRUE)
}
\arguments{
\item{x}{(\code{matrix}, \code{\link{trigrid}}, \code{\link{hexagrid}}) Input coordinates or grid.}

\item{angles}{(\code{numeric}): The \code{vector} of rotation in radians (three values in each dimension). If set to \code{"random"}, the rotation will be random (default). Rotations are executed in X-Y-Z order.}

\item{long}{(\code{numeric}) Rotation in degrees longitude. If given, \code{angles} will be ignored. (see Method 2 description for details!)}

\item{lat}{(\code{numeric}) Rotation in degrees latitude at \code{reflong}. If given, \code{angles} will be ignored. (see Method 2 description for details!)}

\item{reflong}{(\code{numeric}) Reference longitude. If not given it will default to the centroid of the points as given by \code{\link{surfacecentroid}}. (see Method 2 description for details!)}

\item{pivot}{(\code{numeric}): The pivot point of the rotation, \code{vector} of xyz coordinates. For \code{trigrid}-methods it defaults to \code{NA} indicating that the rotation will be around the center of the grid.}

\item{radius}{The radius of the sphere, relevant only if the \code{output="cartesian"} and \code{x} is a longitude-latitude matrix.}

\item{output}{The output format of the rotations, either \code{"polar"} or \code{cartesian}.}

\item{coords}{(\code{character}) Rotation in degrees longitude. If given, \code{angles} will be ignored. (see Method 2 description for details!)}

\item{...}{Arguments passed to class-specific methods.}

\item{projnote}{(\code{logical}): Should messages be shown to remind users to regenerate grid projections with 'sf' and 'sp'?}
}
\value{
Same class object as \code{x}.
}
\description{
Multiple implementations of rotations for coordinate transformation.
}
\details{
The function implements 3D rotations of various class of objects, that are ultimately reduced to individual points. Internally, point rotation is implemented with 3-axis rotations (Method 1),
that are implemented in the X-Y-Z order (note that 3d rotations are not commutative!). For this reason it is not recommended to re-rotate an already rotated object, unless the purpose is to achieve random orientation.

Method 2 parametrizes rotation with three arguments (\code{long}, \code{lat}, \code{reflong}), that can be easier to control. Longitudinal rotations are invariant to the position of the object, but latitudinal
rotation is not. An axis in the equatorial plane will be set perpendicular to the reference longitude (\code{reflong})for latitude-based rotation
(i.e. the latitude difference will equal the latitudinal rotation value only at the reference longitude). If this is not given, then the reference longitude will be that of the centroid of the point cloud.
Note that latitudinal rotation is executed first and only then are the points rotated longitudinally.
}
\keyword{datasets}
