# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' ASQ-Test for the indirect effect - Single mediator path
#'
#' This function takes a vector of significance levels, as well 
#' as estimates and covariances, or 2 U values, for the asq-test 
#' for either one mediator of one path of an unordered mediation scenario.
#' If estimates are passed to the function, the user must specify 
#' what distribution is to be used to find the cumulative probabilities.
#' The smallest significance level
#' for which the test is significant is returned, or 1 if no 
#' provided levels are significant. Additionally,
#' the cutoff, either specified by number of squares or the 
#' percentage towards the center of the transformation region, 
#' can be specified.
#'
#' @param alpha Significance levels to be tested.
#' @param u1,u2 The U values to be used in the test. Given priority over estimates, but both must be supplied.
#' @param V1Dist String value specifying the distribution of the estimate of the independent variable on the mediator. Ignored if u1 and u2 are supplied.
#' @param V1 Value of the estimate of the independent variable on the mediator. Ignored if u1 and u2 are supplied.
#' @param V1_VAR Value of the variance of the estimate of the independent variable on the mediator. Ignored if u1 and u2 are supplied.
#' @param V1_DF Degrees of freedom for V1. Only needed if t-distribution is used.
#' @param V2Dist String value specifying the distribution of the estimate of the mediator (and interaction term) on the response.
#' @param V2 Value of the estimate of the mediator on the response. Ignored if u1 and u2 are supplied.
#' @param V2_VAR Value of the variance of the estimate of the mediator on the response.. Ignored if u1 and u2 are supplied.
#' @param V2_DF Degrees of freedom for V2. Only needed if t-distribution is used.. 
#' @param V2b Value of the estimate of the effect of the interaction of the independent and mediator variable on the response. Ignored if u1 and u2 are supplied.
#' @param V2b_VAR Value of the variance of the estimate of the effect of the interaction of the independent and mediator variable on the response. Ignored if u1 and u2 are supplied.
#' @param V2bmult Value indicating the value of the independent variable used for the interaction. Typically 1.
#' @param V1_V2_cov Value of the covariance between V1 and V2. Typically 0 for fully observed data. 
#' @param V1_V2b_cov Value of the covariance between V1 and V2b. Typically 0 for fully observed data.
#' @param V2_V2b_cov Value of the covariance between V2 and V2b.
#' @param V1_0 Null value for V1.
#' @param V2_0 Null value for V2.
#' @param V2b_0 Null value for V2b.
#' @param numSquares The number of squares to be used in the asq-test. Always superseded by upLim.
#' @param upLim The allowed extension, between 0 and 1, of the squares towards the center of the region
#' @returns The smallest significance level that would reject the null hypothesis. 
#' @export
#' @examples
#' asq_one(c(.05, .01, .001), u1 = .02, u2= .015, upLim = .55)
asq_one <- function(alpha, u1 = NULL, u2 = NULL, V1Dist = NULL, V1 = NULL, V1_VAR = NULL, V1_DF = NULL, V2Dist = NULL, V2 = NULL, V2_VAR = NULL, V2_DF = NULL, V2b = 0, V2b_VAR = 0, V2bmult = 1L, V1_V2_cov = 0, V1_V2b_cov = 0, V2_V2b_cov = 0, V1_0 = 0, V2_0 = 0, V2b_0 = 0, numSquares = 4L, upLim = 0.5) {
    .Call(`_ieTest_asq_one`, alpha, u1, u2, V1Dist, V1, V1_VAR, V1_DF, V2Dist, V2, V2_VAR, V2_DF, V2b, V2b_VAR, V2bmult, V1_V2_cov, V1_V2b_cov, V2_V2b_cov, V1_0, V2_0, V2b_0, numSquares, upLim)
}

#' ASQ-Test for the indirect effect - Ordered Mediators
#'
#' This function takes a vector of significance levels, as well 
#' as estimates and covariances, or 3 U values, for the asq-test 
#' for an ordered mediation scenario.
#' If estimates are passed to the function, the user must specify 
#' what distribution is to be used to find the cumulative probabilities.
#' The smallest significance level
#' for which the test is significant is returned, or 1 if no 
#' provided levels are significant. Additionally,
#' the cutoff, either specified by number of squares or the 
#' percentage towards the center of the transformation region, 
#' can be specified.
#'
#' @param alpha Significance levels to be tested.
#' @param u1,u2,u3 The U values to be used in the test. Given priority over estimates, but all must be supplied.
#' @param V1Dist String value specifying the distribution of the estimate of the independent variable on the first mediator. Ignored if u1, u2, and u3 are supplied.
#' @param V1 Value of the estimate of the independent variable on the first mediator. Ignored if u1, u2, and u3 are supplied.
#' @param V1_VAR Value of the variance of the estimate of the independent variable on the first mediator. Ignored if u1, u2, and u3 are supplied.
#' @param V1_DF Degrees of freedom for V1. Only needed if t-distribution is used.
#' @param V2Dist String value specifying the distribution of the estimate of the first mediator (and interaction term) on the second mediator.
#' @param V2 Value of the estimate of the first mediator on the second mediator. Ignored if u1, u2, and u3 are supplied.
#' @param V2_VAR Value of the variance of the estimate of the first mediator on the second mediator. Ignored if u1, u2, and u3 are supplied.
#' @param V2_DF Degrees of freedom for V2. 
#' @param V2b Value of the estimate of the effect of the interaction of the independent and first mediator variable on the second mediator. Ignored if u1, u2, and u3 are supplied.
#' @param V2b_VAR Value of the variance of the estimate of the effect of the interaction of the independent and first mediator variable on the second mediator. Ignored if u1, u2, and u3 are supplied.
#' @param V2bmult Value indicating the value of the independent variable used for the interactions. Typically 1.
#' @param V3Dist String value specifying the distribution of the estimate of the second mediator (and interaction term) on the response.
#' @param V3 Value of the estimate of the second mediator on the response. Ignored if u1, u2, and u3 are supplied.
#' @param V3_VAR Value of the variance of the estimate of the second mediator on the response. Ignored if u1, u2, and u3 are supplied.
#' @param V3_DF Degrees of freedom for V3. 
#' @param V3b Value of the estimate of the effect of the interaction of the independent and second mediator variable on the response. Ignored if u1, u2, and u3 are supplied.
#' @param V3b_VAR Value of the variance of the estimate of the effect of the interaction of the independent and second mediator variable on the response. Ignored if u1, u2, and u3 are supplied.
#' @param V1_V2_cov Value of the covariance between V1 and V2. Typically 0 for fully observed data. 
#' @param V1_V2b_cov Value of the covariance between V1 and V2b. Typically 0 for fully observed data.
#' @param V1_V3_cov Value of the covariance between V1 and V3. Typically 0 for fully observed data. 
#' @param V1_V3b_cov Value of the covariance between V1 and V3b. Typically 0 for fully observed data.
#' @param V2_V2b_cov Value of the covariance between V2 and V2b. 
#' @param V2_V3_cov Value of the covariance between V2 and V3. Typically 0 for fully observed data. 
#' @param V2_V3b_cov Value of the covariance between V2 and V3b. Typically 0 for fully observed data.
#' @param V2b_V3_cov Value of the covariance between V2b and V3. Typically 0 for fully observed data. 
#' @param V2b_V3b_cov Value of the covariance between V2b and V3b. Typically 0 for fully observed data.
#' @param V3_V3b_cov Value of the covariance between V3 and V3b.
#' @param V1_0 Null value for V1.
#' @param V2_0 Null value for V2.
#' @param V2b_0 Null value for V2b.
#' @param V3_0 Null value for V3.
#' @param V3b_0 Null value for V3b.
#' @param numSquares The number of squares to be used in the asq-test. Always superseded by upLim.
#' @param upLim The allowed extension, between 0 and 1, of the squares towards the center of the region
#' @returns The smallest significance level that would reject the null hypothesis. 
#' @export
#' @examples
#' asq_ord(c(.05, .01, .001), u1 = .02, u2= .015, u3 = .995, upLim = .55)
asq_ord <- function(alpha, u1 = NULL, u2 = NULL, u3 = NULL, V1Dist = NULL, V1 = NULL, V1_VAR = NULL, V1_DF = NULL, V2Dist = NULL, V2 = NULL, V2_VAR = NULL, V2_DF = NULL, V2b = 0, V2b_VAR = 0, V2bmult = 1L, V3Dist = NULL, V3 = NULL, V3_VAR = NULL, V3_DF = NULL, V3b = 0, V3b_VAR = 0, V1_V2_cov = 0, V1_V2b_cov = 0, V1_V3_cov = 0, V1_V3b_cov = 0, V2_V2b_cov = 0, V2_V3_cov = 0, V2_V3b_cov = 0, V2b_V3_cov = 0, V2b_V3b_cov = 0, V3_V3b_cov = 0, V1_0 = 0, V2_0 = 0, V2b_0 = 0, V3_0 = 0, V3b_0 = 0, numSquares = 4L, upLim = 0.5) {
    .Call(`_ieTest_asq_ord`, alpha, u1, u2, u3, V1Dist, V1, V1_VAR, V1_DF, V2Dist, V2, V2_VAR, V2_DF, V2b, V2b_VAR, V2bmult, V3Dist, V3, V3_VAR, V3_DF, V3b, V3b_VAR, V1_V2_cov, V1_V2b_cov, V1_V3_cov, V1_V3b_cov, V2_V2b_cov, V2_V3_cov, V2_V3b_cov, V2b_V3_cov, V2b_V3b_cov, V3_V3b_cov, V1_0, V2_0, V2b_0, V3_0, V3b_0, numSquares, upLim)
}

#' Is the mediation effect significant?
#'
#' This function takes 3 U values for the asq-test for 2 ordered
#' mediators, as well as an alpha level. It returns whether the
#' test would reject at the given alpha level. Additionally,
#' the cutoff, either specified by number of squares or the 
#' percentage towards the center of the transformation region, 
#' can be specified.
#' This function is primarily called by the asq_ord function
#' to determine if the test is significant at one of a chosen
#' set of alpha values. 
#'
#' @param alpha Significance level for the test.
#' @param u1,u2,u3 The U values to be used in the test
#' @param numSquares The number of squares to be used in the asq-test. Always superceded by upLim
#' @param upLim The allowed extension, between 0 and 1, of the squares towards the center of the region
#' @returns A boolean variable indicating if the indirect effect null hypothesis is rejected.
#' @export
#' @examples
#' asq_ord_bool(.05, .02, .015, .995, upLim = .75)
asq_ord_bool <- function(alpha, u1, u2, u3, numSquares = 4L, upLim = 0.5) {
    .Call(`_ieTest_asq_ord_bool`, alpha, u1, u2, u3, numSquares, upLim)
}

#' MaxP test for the indirect effect - Single mediator path
#'
#' This function takes 
#' estimates and covariances, or 2 U values, for the maxP test 
#' for either one mediator of one path of an unordered mediation scenario.
#' If estimates are passed to the function, the user must specify 
#' what distribution is to be used to find the cumulative probabilities.
#' The maximum p-value is returned. 
#'
#' @param u1,u2 The U values to be used in the test. Given priority over estimates, but both must be supplied.
#' @param V1Dist String value specifying the distribution of the estimate of the independent variable on the mediator. Ignored if u1 and u2 are supplied.
#' @param V1 Value of the estimate of the independent variable on the mediator. Ignored if u1 and u2 are supplied.
#' @param V1_VAR Value of the variance of the estimate of the independent variable on the mediator. Ignored if u1 and u2 are supplied.
#' @param V1_DF Degrees of freedom for V1. Only needed if t-distribution is used.
#' @param V2Dist String value specifying the distribution of the estimate of the mediator (and interaction term) on the response.
#' @param V2 Value of the estimate of the mediator on the response. Ignored if u1 and u2 are supplied.
#' @param V2_VAR Value of the variance of the estimate of the mediator on the response.. Ignored if u1 and u2 are supplied.
#' @param V2_DF Degrees of freedom for V2. Only needed if t-distribution is used.. 
#' @param V2b Value of the estimate of the effect of the interaction of the independent and mediator variable on the response. Ignored if u1 and u2 are supplied.
#' @param V2b_VAR Value of the variance of the estimate of the effect of the interaction of the independent and mediator variable on the response. Ignored if u1 and u2 are supplied.
#' @param V2bmult Value indicating the value of the independent variable used for the interaction. Typically 1.
#' @param V1_V2_cov Value of the covariance between V1 and V2. Typically 0 for fully observed data. 
#' @param V1_V2b_cov Value of the covariance between V1 and V2b. Typically 0 for fully observed data.
#' @param V2_V2b_cov Value of the covariance between V2 and V2b.
#' @param V1_0 Null value for V1.
#' @param V2_0 Null value for V2.
#' @param V2b_0 Null value for V2b.
#' @returns The p-value of the test in the form of the larger of the p-values for the individual parameters.
#' @export
#' @examples
#' maxp_one(u1 = .02, u2= .015)
maxp_one <- function(u1 = NULL, u2 = NULL, V1Dist = NULL, V1 = NULL, V1_VAR = NULL, V1_DF = NULL, V2Dist = NULL, V2 = NULL, V2_VAR = NULL, V2_DF = NULL, V2b = 0, V2b_VAR = 0, V2bmult = 1L, V1_V2_cov = 0, V1_V2b_cov = 0, V2_V2b_cov = 0, V1_0 = 0, V2_0 = 0, V2b_0 = 0) {
    .Call(`_ieTest_maxp_one`, u1, u2, V1Dist, V1, V1_VAR, V1_DF, V2Dist, V2, V2_VAR, V2_DF, V2b, V2b_VAR, V2bmult, V1_V2_cov, V1_V2b_cov, V2_V2b_cov, V1_0, V2_0, V2b_0)
}

#' MaxP-Test for the indirect effect - Ordered Mediators
#'
#' This function takes 
#' estimates and covariances, or 3 U values, for the maxp-test 
#' for an ordered mediation scenario.
#' If estimates are passed to the function, the user must specify 
#' what distribution is to be used to find the cumulative probabilities.
#' The p-value of the maxp-test is returned. 
#'
#' @param u1,u2,u3 The U values to be used in the test. Given priority over estimates, but all must be supplied.
#' @param V1Dist String value specifying the distribution of the estimate of the independent variable on the first mediator. Ignored if u1, u2, and u3 are supplied.
#' @param V1 Value of the estimate of the independent variable on the first mediator. Ignored if u1, u2, and u3 are supplied.
#' @param V1_VAR Value of the variance of the estimate of the independent variable on the first mediator. Ignored if u1, u2, and u3 are supplied.
#' @param V1_DF Degrees of freedom for V1. Only needed if t-distribution is used.
#' @param V2Dist String value specifying the distribution of the estimate of the first mediator (and interaction term) on the second mediator.
#' @param V2 Value of the estimate of the first mediator on the second mediator. Ignored if u1, u2, and u3 are supplied.
#' @param V2_VAR Value of the variance of the estimate of the first mediator on the second mediator. Ignored if u1, u2, and u3 are supplied.
#' @param V2_DF Degrees of freedom for V2. 
#' @param V2b Value of the estimate of the effect of the interaction of the independent and first mediator variable on the second mediator. Ignored if u1, u2, and u3 are supplied.
#' @param V2b_VAR Value of the variance of the estimate of the effect of the interaction of the independent and first mediator variable on the second mediator. Ignored if u1, u2, and u3 are supplied.
#' @param V2bmult Value indicating the value of the independent variable used for the interactions. Typically 1.
#' @param V3Dist String value specifying the distribution of the estimate of the second mediator (and interaction term) on the response.
#' @param V3 Value of the estimate of the second mediator on the response. Ignored if u1, u2, and u3 are supplied.
#' @param V3_VAR Value of the variance of the estimate of the second mediator on the response. Ignored if u1, u2, and u3 are supplied.
#' @param V3_DF Degrees of freedom for V3. 
#' @param V3b Value of the estimate of the effect of the interaction of the independent and second mediator variable on the response. Ignored if u1, u2, and u3 are supplied.
#' @param V3b_VAR Value of the variance of the estimate of the effect of the interaction of the independent and second mediator variable on the response. Ignored if u1, u2, and u3 are supplied.
#' @param V1_V2_cov Value of the covariance between V1 and V2. Typically 0 for fully observed data. 
#' @param V1_V2b_cov Value of the covariance between V1 and V2b. Typically 0 for fully observed data.
#' @param V1_V3_cov Value of the covariance between V1 and V3. Typically 0 for fully observed data. 
#' @param V1_V3b_cov Value of the covariance between V1 and V3b. Typically 0 for fully observed data.
#' @param V2_V2b_cov Value of the covariance between V2 and V2b 
#' @param V2_V3_cov Value of the covariance between V2 and V3 Typically 0 for fully observed data. 
#' @param V2_V3b_cov Value of the covariance between V2 and V3b Typically 0 for fully observed data.
#' @param V2b_V3_cov Value of the covariance between V2b and V3. Typically 0 for fully observed data. 
#' @param V2b_V3b_cov Value of the covariance between V2b and V3b Typically 0 for fully observed data.
#' @param V3_V3b_cov Value of the covariance between V3 and V3b.
#' @param V1_0 Null value for V1.
#' @param V2_0 Null value for V2.
#' @param V2b_0 Null value for V2b.
#' @param V3_0 Null value for V3.
#' @param V3b_0 Null value for V3b.
#' @returns The p-value of the test in the form of the larger of the p-values for the individual parameters.
#' @export
#' @examples
#' maxp_ord( u1 = .02, u2= .015, u3 = .995)
maxp_ord <- function(u1 = NULL, u2 = NULL, u3 = NULL, V1Dist = NULL, V1 = NULL, V1_VAR = NULL, V1_DF = NULL, V2Dist = NULL, V2 = NULL, V2_VAR = NULL, V2_DF = NULL, V2b = 0, V2b_VAR = 0, V2bmult = 1L, V3Dist = NULL, V3 = NULL, V3_VAR = NULL, V3_DF = NULL, V3b = 0, V3b_VAR = 0, V1_V2_cov = 0, V1_V2b_cov = 0, V1_V3_cov = 0, V1_V3b_cov = 0, V2_V2b_cov = 0, V2_V3_cov = 0, V2_V3b_cov = 0, V2b_V3_cov = 0, V2b_V3b_cov = 0, V3_V3b_cov = 0, V1_0 = 0, V2_0 = 0, V2b_0 = 0, V3_0 = 0, V3b_0 = 0) {
    .Call(`_ieTest_maxp_ord`, u1, u2, u3, V1Dist, V1, V1_VAR, V1_DF, V2Dist, V2, V2_VAR, V2_DF, V2b, V2b_VAR, V2bmult, V3Dist, V3, V3_VAR, V3_DF, V3b, V3b_VAR, V1_V2_cov, V1_V2b_cov, V1_V3_cov, V1_V3b_cov, V2_V2b_cov, V2_V3_cov, V2_V3b_cov, V2b_V3_cov, V2b_V3b_cov, V3_V3b_cov, V1_0, V2_0, V2b_0, V3_0, V3b_0)
}

#' PS-Test for the indirect effect - Single mediator path
#'
#' This function takes 
#' estimates and covariances, or 2 U values, for the ps-test 
#' for either one mediator of one path of an unordered mediation scenario.
#' If estimates are passed to the function, the user must specify 
#' what distribution is to be used to find the cumulative probabilities.
#' The p-value of the ps-test is returned. Additionally,
#' the cutoff, specified by the 
#' percentage towards the center of the transformation region, 
#' can be specified.
#'
#' @param u1,u2 The U values to be used in the test. Given priority over estimates, but both must be supplied.
#' @param V1Dist String value specifying the distribution of the estimate of the independent variable on the mediator. Ignored if u1 and u2 are supplied.
#' @param V1 Value of the estimate of the independent variable on the mediator. Ignored if u1 and u2 are supplied.
#' @param V1_VAR Value of the variance of the estimate of the independent variable on the mediator. Ignored if u1 and u2 are supplied.
#' @param V1_DF Degrees of freedom for V1. Only needed if t-distribution is used.
#' @param V2Dist String value specifying the distribution of the estimate of the mediator (and interaction term) on the response.
#' @param V2 Value of the estimate of the mediator on the response. Ignored if u1 and u2 are supplied.
#' @param V2_VAR Value of the variance of the estimate of the mediator on the response.. Ignored if u1 and u2 are supplied.
#' @param V2_DF Degrees of freedom for V2. Only needed if t-distribution is used.. 
#' @param V2b Value of the estimate of the effect of the interaction of the independent and mediator variable on the response. Ignored if u1 and u2 are supplied.
#' @param V2b_VAR Value of the variance of the estimate of the effect of the interaction of the independent and mediator variable on the response. Ignored if u1 and u2 are supplied.
#' @param V2bmult Value indicating the value of the independent variable used for the interaction. Typically 1.
#' @param V1_V2_cov Value of the covariance between V1 and V2. Typically 0 for fully observed data. 
#' @param V1_V2b_cov Value of the covariance between V1 and V2b. Typically 0 for fully observed data.
#' @param V2_V2b_cov Value of the covariance between V2 and V2b.
#' @param V1_0 Null value for V1.
#' @param V2_0 Null value for V2.
#' @param V2b_0 Null value for V2b.
#' @param upLim The allowed extension, between 0 and 1, of the band towards the center of the region
#' @param alpha Used to ensure correctly controlled type I error for large values of upLim. 
#' @returns The smallest alpha value for which the generated rejection region leads to rejection of the hypothesis test. Can be used as a p-value.
#' @export
#' @examples
#' ps_one(u1 = .02, u2= .015, upLim = .55)
ps_one <- function(u1 = NULL, u2 = NULL, V1Dist = NULL, V1 = NULL, V1_VAR = NULL, V1_DF = NULL, V2Dist = NULL, V2 = NULL, V2_VAR = NULL, V2_DF = NULL, V2b = 0, V2b_VAR = 0, V2bmult = 1L, V1_V2_cov = 0, V1_V2b_cov = 0, V2_V2b_cov = 0, V1_0 = 0, V2_0 = 0, V2b_0 = 0, upLim = 0.5, alpha = NULL) {
    .Call(`_ieTest_ps_one`, u1, u2, V1Dist, V1, V1_VAR, V1_DF, V2Dist, V2, V2_VAR, V2_DF, V2b, V2b_VAR, V2bmult, V1_V2_cov, V1_V2b_cov, V2_V2b_cov, V1_0, V2_0, V2b_0, upLim, alpha)
}

modS_one <- function(x1, s11, df1, x2, s22, df2, upLim = .5, x10 = 0, x20 = 0, s12 = 0) {
    .Call(`_ieTest_modS_one`, x1, s11, df1, x2, s22, df2, upLim, x10, x20, s12)
}

ps_one_old <- function(x1, s11, df1, x2, s22, df2, upLim = .5, x10 = 0, x20 = 0, s12 = 0) {
    .Call(`_ieTest_ps_one_old`, x1, s11, df1, x2, s22, df2, upLim, x10, x20, s12)
}

#' PS-Test for the indirect effect - Ordered Mediators
#'
#' This function takes 
#' estimates and covariances, or 3 U values, for the ps-test 
#' for an ordered mediation scenario.
#' If estimates are passed to the function, the user must specify 
#' what distribution is to be used to find the cumulative probabilities.
#' The p-value of the ps-test is returned. Additionally,
#' the cutoff, specified by the 
#' percentage towards the center of the transformation region, 
#' can be specified.
#'
#' @param u1,u2,u3 The U values to be used in the test. Given priority over estimates, but all must be supplied.
#' @param V1Dist String value specifying the distribution of the estimate of the independent variable on the first mediator. Ignored if u1, u2, and u3 are supplied.
#' @param V1 Value of the estimate of the independent variable on the first mediator. Ignored if u1, u2, and u3 are supplied.
#' @param V1_VAR Value of the variance of the estimate of the independent variable on the first mediator. Ignored if u1, u2, and u3 are supplied.
#' @param V1_DF Degrees of freedom for V1. Only needed if t-distribution is used.
#' @param V2Dist String value specifying the distribution of the estimate of the first mediator (and interaction term) on the second mediator.
#' @param V2 Value of the estimate of the first mediator on the second mediator. Ignored if u1, u2, and u3 are supplied.
#' @param V2_VAR Value of the variance of the estimate of the first mediator on the second mediator. Ignored if u1, u2, and u3 are supplied.
#' @param V2_DF Degrees of freedom for V2. 
#' @param V2b Value of the estimate of the effect of the interaction of the independent and first mediator variable on the second mediator. Ignored if u1, u2, and u3 are supplied.
#' @param V2b_VAR Value of the variance of the estimate of the effect of the interaction of the independent and first mediator variable on the second mediator. Ignored if u1, u2, and u3 are supplied.
#' @param V2bmult Value indicating the value of the independent variable used for the interaction. Typically 1.
#' @param V3Dist String value specifying the distribution of the estimate of the second mediator (and interaction term) on the response.
#' @param V3 Value of the estimate of the second mediator on the response. Ignored if u1, u2, and u3 are supplied.
#' @param V3_VAR Value of the variance of the estimate of the second mediator on the response. Ignored if u1, u2, and u3 are supplied.
#' @param V3_DF Degrees of freedom for V3. 
#' @param V3b Value of the estimate of the effect of the interaction of the independent and second mediator variable on the response. Ignored if u1, u2, and u3 are supplied.
#' @param V3b_VAR Value of the variance of the estimate of the effect of the interaction of the independent and second mediator variable on the response. Ignored if u1, u2, and u3 are supplied.
#' @param V1_V2_cov Value of the covariance between V1 and V2. Typically 0 for fully observed data. 
#' @param V1_V2b_cov Value of the covariance between V1 and V2b. Typically 0 for fully observed data.
#' @param V1_V3_cov Value of the covariance between V1 and V3. Typically 0 for fully observed data. 
#' @param V1_V3b_cov Value of the covariance between V1 and V3b. Typically 0 for fully observed data.
#' @param V2_V2b_cov Value of the covariance between V2 and V2b 
#' @param V2_V3_cov Value of the covariance between V2 and V3 Typically 0 for fully observed data. 
#' @param V2_V3b_cov Value of the covariance between V2 and V3b Typically 0 for fully observed data.
#' @param V2b_V3_cov Value of the covariance between V2b and V3. Typically 0 for fully observed data. 
#' @param V2b_V3b_cov Value of the covariance between V2b and V3b Typically 0 for fully observed data.
#' @param V3_V3b_cov Value of the covariance between V3 and V3b.
#' @param V1_0 Null value for V1.
#' @param V2_0 Null value for V2.
#' @param V2b_0 Null value for V2b.
#' @param V3_0 Null value for V3.
#' @param V3b_0 Null value for V3b.
#' @param upLim The allowed extension, between 0 and 1, of the band towards the center of the region.
#' @param alpha Used to ensure correctly controlled type I error for large values of upLim. 
#' @returns The smallest alpha value for which the generated rejection region leads to rejection of the hypothesis test. Can be used as a p-value.
#' @export
#' @examples
#' ps_ord( u1 = .02, u2= .015, u3 = .995, upLim = .55)
ps_ord <- function(u1 = NULL, u2 = NULL, u3 = NULL, V1Dist = NULL, V1 = NULL, V1_VAR = NULL, V1_DF = NULL, V2Dist = NULL, V2 = NULL, V2_VAR = NULL, V2_DF = NULL, V2b = 0, V2b_VAR = 0, V2bmult = 1L, V3Dist = NULL, V3 = NULL, V3_VAR = NULL, V3_DF = NULL, V3b = 0, V3b_VAR = 0, V1_V2_cov = 0, V1_V2b_cov = 0, V1_V3_cov = 0, V1_V3b_cov = 0, V2_V2b_cov = 0, V2_V3_cov = 0, V2_V3b_cov = 0, V2b_V3_cov = 0, V2b_V3b_cov = 0, V3_V3b_cov = 0, V1_0 = 0, V2_0 = 0, V2b_0 = 0, V3_0 = 0, V3b_0 = 0, upLim = 0.5, alpha = NULL) {
    .Call(`_ieTest_ps_ord`, u1, u2, u3, V1Dist, V1, V1_VAR, V1_DF, V2Dist, V2, V2_VAR, V2_DF, V2b, V2b_VAR, V2bmult, V3Dist, V3, V3_VAR, V3_DF, V3b, V3b_VAR, V1_V2_cov, V1_V2b_cov, V1_V3_cov, V1_V3b_cov, V2_V2b_cov, V2_V3_cov, V2_V3b_cov, V2b_V3_cov, V2b_V3b_cov, V3_V3b_cov, V1_0, V2_0, V2b_0, V3_0, V3b_0, upLim, alpha)
}

#' S test for Indirect Effect for a single mediator
#'
#' This function takes 
#' the estimate of the effect of the independent variable on the mediator  
#' and the effect of the mediator on the effect as well as their variances and 
#' performs the S test. Alternative null hypothesis can be specified as well. 
#' Additionally, covariances of the parameters can be specified for cases 
#' involving missing data where the estimates may be correlated.
#'
#' @param alpha Significance level for the test of significance
#' @param x1 Numeric value of the estimated first effect of interest
#' @param s11 Numeric value of the estimated first effect variance
#' @param df1 Degrees of freedom for estimate x1 
#' @param x2 Numeric value of estimated second effect of interest 
#' @param s22 Numeric value of the estimated second effect variance 
#' @param df2 Degrees of freedom for estimate x2. Often the same as x1 
#' @param x10 Optional numeric value of alternative null hypothesis value for the first effect 
#' @param x20 Optional numeric value of alternative null hypothesis value for the second effect 
#' @param s12 Specification of covariance between x1 and x2. Typically 0, but may be non-zero in the prescence of missing data 
#' @returns Boolean True/False value of whether the test rejects the Null hypothesis
#' @references Berger, Roger L. Likelihood Ratio Tests and Intersection-Union Tests. Advances in Statistical Decision Theory and Applications, 2011.
#' @note The function for the S-test does not incorporate interactions between the independent and mediating variables. 
#' The user must first calculate the mean and variance of the second product term to be used in the function call. 
#' @export
#' @examples
#' sTest_one(0.05, .5, 1, 100, -.25, .1, 100)
sTest_one <- function(alpha, x1, s11, df1, x2, s22, df2, x10 = 0, x20 = 0, s12 = 0) {
    .Call(`_ieTest_sTest_one`, alpha, x1, s11, df1, x2, s22, df2, x10, x20, s12)
}

#' Sobel test for the indirect effect - Single mediator path
#'
#' This function takes the parameter estimates and covariances
#' and performs the Sobel test for one mediator, or a single
#' mediator path for multiple unordered mediators.
#'
#' @param mu1 Value of the estimate of the independent variable on the mediator.
#' @param sig1 Value of the variance of the estimate of the independent variable on the mediator.
#' @param mu2 Value of the estimate of the mediator on the response.  
#' @param sig2 Value of the variance of the estimate of the mediator on the response. 
#' @param sig12 Value of the covariance between mu1 and mu2.
#' @param indL Value indicating the value of the independent variable used for the interaction. Typically 1.
#' @param mu3 Value of the estimate of the effect of the interaction of the independent and mediator variable on the response.
#' @param sig3 Value of the variance of the estimate of the effect of the interaction of the independent and mediator variable on the response.
#' @param sig13 Value of the covariance between mu1 and mu3.
#' @param sig23 Value of the covariance between mu2 and mu3.
#' @param mu1_0 Null value for mu1.
#' @param mu2_0 Null value for mu2.
#' @param mu3_0 Null value for mu3.
#' @returns A p-value for the test for the indirect effect.
#' @export
#' @examples
#' sobelTest_one(1, .1, .25, .01, .05)
sobelTest_one <- function(mu1, sig1, mu2, sig2, sig12, indL = 1, mu3 = 0L, sig3 = 0L, sig13 = 0L, sig23 = 0L, mu1_0 = 0, mu2_0 = 0, mu3_0 = 0) {
    .Call(`_ieTest_sobelTest_one`, mu1, sig1, mu2, sig2, sig12, indL, mu3, sig3, sig13, sig23, mu1_0, mu2_0, mu3_0)
}

#' Sobel test for the indirect effect - Two ordered mediator path
#'
#' This function takes the parameter estimates and covariances
#' and performs the Sobel test for two ordered mediators.
#'
#' @param mu1 Value of the estimate of the independent variable on the first mediator.
#' @param sig1 Value of the variance of the estimate of the independent variable on the first mediator.
#' @param mu2 Value of the estimate of the first mediator on the second mediator.  
#' @param sig2 Value of the variance of the estimate of the first mediator on the second mediator.  
#' @param mu3 Value of the estimate of the second mediator on the response.
#' @param sig3 Value of the variance of the estimate of the second mediator on the response.
#' @param mu2b Value of the estimate of the effect of the interaction of the independent and first mediator variable on the second mediator. 
#' @param sig2b Value of the variance of the estimate of the effect of the interaction of the independent and first mediator variable on the second mediator.
#' @param mu3b Value of the estimate of the effect of the interaction of the independent and second mediator variable on the response. 
#' @param sig3b Value of the variance of the estimate of the effect of the interaction of the independent and second mediator variable on the response.
#' @param sig12 Value of the covariance between mu1 and mu2.
#' @param sig12b Value of the covariance between mu1 and mu2b. 
#' @param sig13 Value of the covariance between mu1 and mu3. 
#' @param sig13b Value of the covariance between mu1 and mu3b.
#' @param sig22b Value of the covariance between mu2 and mu2b.
#' @param sig23 Value of the covariance between mu2 and mu3.
#' @param sig23b Value of the covariance between mu2 and mu2b.
#' @param sig2b3 Value of the covariance between mu2b and mu3. 
#' @param sig2b3b Value of the covariance between mu2b and mu3b.
#' @param sig33b Value of the covariance between mu3 and mu3b.
#' @param indL Value indicating the value of the independent variable used for the interaction. Typically 1.
#' @param mu1_0 Null value for mu1.
#' @param mu2_0 Null value for mu2.
#' @param mu3_0 Null value for mu3.
#' @param mu2b_0 Null value for mu2b.
#' @param mu3b_0 Null value for mu3b.
#' @returns A p-value for the test for the indirect effect.
#' @export
#' @examples
#' sobelTest_ord(1, .1, .25, .01, 0, 0, .15, .01, 0, 0)
sobelTest_ord <- function(mu1, sig1, mu2, sig2, mu3, sig3, mu2b = 0L, sig2b = 0L, mu3b = 0L, sig3b = 0L, sig12 = 0L, sig12b = 0L, sig13 = 0L, sig13b = 0L, sig22b = 0L, sig23 = 0L, sig23b = 0L, sig2b3 = 0L, sig2b3b = 0L, sig33b = 0L, indL = 1L, mu1_0 = 0, mu2_0 = 0, mu3_0 = 0, mu2b_0 = 0, mu3b_0 = 0) {
    .Call(`_ieTest_sobelTest_ord`, mu1, sig1, mu2, sig2, mu3, sig3, mu2b, sig2b, mu3b, sig3b, sig12, sig12b, sig13, sig13b, sig22b, sig23, sig23b, sig2b3, sig2b3b, sig33b, indL, mu1_0, mu2_0, mu3_0, mu2b_0, mu3b_0)
}

#' Sobel test for the indirect effect - Two ordered mediator path
#'
#' This function takes the parameter estimates and covariances
#' and performs the Sobel test for two ordered mediators.
#'
#' @param mu1 Value of the estimate of the independent variable on the first mediator.
#' @param sig1 Value of the variance of the estimate of the independent variable on the first mediator.
#' @param mu2 Value of the estimate of the first mediator on the response.  
#' @param sig2 Value of the variance of the estimate of the first mediator on the response.  
#' @param mu3 Value of the estimate of the independent variable on the second mediator.
#' @param sig3 Value of the variance of the estimate of the independent variable on the second mediator.
#' @param mu4 Value of the estimate of the second mediator on the response.  
#' @param sig4 Value of the variance of the estimate of the second mediator on the response.  
#' @param mu2b Value of the estimate of the effect of the interaction of the independent and first mediator variable on the response.
#' @param sig2b Value of the variance of the estimate of the effect of the interaction of the independent and first mediator variable on the response.
#' @param mu4b Value of the estimate of the effect of the interaction of the independent and second mediator variable on the response. 
#' @param sig4b Value of the variance of the estimate of the effect of the interaction of the independent and second mediator variable on the response.
#' @param sig12 Value of the covariance between mu1 and mu2.
#' @param sig12b Value of the covariance between mu1 and mu2b. 
#' @param sig13 Value of the covariance between mu1 and mu3. 
#' @param sig14 Value of the covariance between mu1 and mu4. 
#' @param sig14b Value of the covariance between mu1 and mu4b.
#' @param sig22b Value of the covariance between mu1 and mu2b. 
#' @param sig23 Value of the covariance between mu2 and mu3. 
#' @param sig24 Value of the covariance between mu2 and mu4. 
#' @param sig24b Value of the covariance between mu2 and mu4b.
#' @param sig2b3 Value of the covariance between mu2b and mu3. 
#' @param sig2b4 Value of the covariance between mu2b and mu4. 
#' @param sig2b4b Value of the covariance between mu2b and mu4b.
#' @param sig34 Value of the covariance between mu3 and mu4. 
#' @param sig34b Value of the covariance between mu3 and mu4b.
#' @param sig44b Value of the covariance between mu4 and mu4b.
#' @param indL Value indicating the value of the independent variable used for the interaction. Typically 1.
#' @param mu1_0 Null value for mu1.
#' @param mu2_0 Null value for mu2.
#' @param mu3_0 Null value for mu3.
#' @param mu4_0 Null value for mu4.
#' @param mu2b_0 Null value for mu2b.
#' @param mu4b_0 Null value for mu4b.
#' @returns A p-value for the test for the indirect effect.
#' @export
#' @examples
#' sobelTest_unord(1, .1, .25, .01, 0, 0, .15, .01, 0, 0, 0, 0)
sobelTest_unord <- function(mu1, sig1, mu2, sig2, mu3, sig3, mu4, sig4, mu2b, sig2b, mu4b, sig4b, sig12 = 0L, sig12b = 0L, sig13 = 0L, sig14 = 0L, sig14b = 0L, sig22b = 0L, sig23 = 0L, sig24 = 0L, sig24b = 0L, sig2b3 = 0L, sig2b4 = 0L, sig2b4b = 0L, sig34 = 0L, sig34b = 0L, sig44b = 0L, indL = 1L, mu1_0 = 0, mu2_0 = 0, mu3_0 = 0, mu4_0 = 0, mu2b_0 = 0, mu4b_0 = 0) {
    .Call(`_ieTest_sobelTest_unord`, mu1, sig1, mu2, sig2, mu3, sig3, mu4, sig4, mu2b, sig2b, mu4b, sig4b, sig12, sig12b, sig13, sig14, sig14b, sig22b, sig23, sig24, sig24b, sig2b3, sig2b4, sig2b4b, sig34, sig34b, sig44b, indL, mu1_0, mu2_0, mu3_0, mu4_0, mu2b_0, mu4b_0)
}

