% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igfetchr.R
\name{ig_close_session}
\alias{ig_close_session}
\alias{ig_logout}
\title{Close session}
\usage{
ig_close_session(auth, mock_response = NULL)

ig_logout(auth, mock_response = NULL)
}
\arguments{
\item{auth}{List. Authentication details from `ig_auth()`, including `cst`, `security`, 
`base_url`, `api_key`, and `acc_number`.}

\item{mock_response}{Logical. Optional mock response for testing (returns `TRUE` if 
provided). Defaults to `NULL`.}
}
\value{
Logical `TRUE` if the session was closed successfully.
}
\description{
Closes the authenticated IG API session.

Alias for `ig_close_session()`.
}
\examples{
\dontrun{
# Authenticate and close session
auth <- ig_auth(
  username = "your_username",
  password = "your_password",
  api_key = "your_api_key",
  acc_type = "DEMO",
  acc_number = "ABC123"
)
ig_close_session(auth)

# Using mock response for testing
ig_close_session(auth, mock_response = TRUE)
}

}
