% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_to_names_fill.R
\name{row_to_names_fill}
\alias{row_to_names_fill}
\title{Elevate rows to be the column names of a data.frame and fill row-wise if needed}
\usage{
row_to_names_fill(
  data,
  row_number,
  fill_missing = TRUE,
  remove_row = TRUE,
  remove_rows_above = TRUE,
  sep = "_"
)
}
\arguments{
\item{data}{A data frame.}

\item{row_number}{A numeric vector with he row indices of \code{data} containing the
variable names. Allows for multiple rows input as a numeric vector. If multiple
rows, values in the same column would be pasted with the \code{sep} argument as a
separator. NAs are ignored.}

\item{fill_missing}{A logical vector of length 1 or of length \code{length(row_number)}.
Every value in the vector denotes for the matching row in \code{data[row_number, ]} if
the row should fill missing values (from left to right). If \code{TRUE} for a row,
all missing values following a non-missing value will be replaced with that
preceding non-missing value.}

\item{remove_row}{A logical vector of length 1, denoting if the row \code{row_number}
should be removed from the resulting data.frame.}

\item{remove_rows_above}{A logical vector of length 1, denoting if the rows above
\code{row_number} - that is, between \code{1:(row_number-1)} - should be removed
from the resulting data.frame, in the case that \code{row_number != 1}.}

\item{sep}{A character vector of length 1 to separate the values in the case of
multiple rows input to \code{row_number}.}
}
\value{
A data frame (class \code{data.frame}) with the same structure as the input \code{data},
but with column names derived from the specified row(s). The returned data frame
has the same number of columns as the input, with rows removed according to the
\code{remove_row} and \code{remove_rows_above} parameters. All data types and values are
preserved from the original data frame.
}
\description{
Casts data from rows to the column names of a data frame, with the option to fill
missing values row-wise. This utility is helpful in the case of merged cells in
Microsoft Excel, where the merged range has data only in the first (unmerged) cell.
This function is similar to \code{janitor::row_to_names()}, with the exception of
the fill utility.
}
\examples{
df <- data.frame(
  a = 1:6,
  b = rep(c("x", NA), 3),
  c = letters[1:6]
)

df

row_to_names_fill(df, 2:3)
row_to_names_fill(df, 2:3, sep = ".")
row_to_names_fill(df, 2:4, fill_missing = c(TRUE, FALSE, FALSE))

}
