% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Priors.R
\name{PriorsSpecification}
\alias{PriorsSpecification}
\alias{add_prior}
\alias{define_priors}
\alias{as.priors}
\title{Specify the Prior Distributions for All Parameters}
\usage{
add_prior(
  ...,
  dist_base_name = NULL,
  density_fn = NULL,
  quantile_fn = NULL,
  parameter_name = NULL
)

define_priors(..., prior_df = NULL)

as.priors(df, ...)
}
\arguments{
\item{...}{Optional. In add_prior: Named inputs to be passed to the RNG functions. In define_priors: The results of
add_prior calls - one for each parameter that is being calibrated.}

\item{dist_base_name}{Optional character(1). The base name of the RNG function set (or the column with the dist_base_name
info in as.priors) for the prior distribution.}

\item{density_fn}{Optional character(1). The name of the RNG density function (or the column with the density_fn
info in as.priors) for the prior distribution.}

\item{quantile_fn}{Optional character(1). The name of the RNG quantile function (or the column with the quantile_fn
info in as.priors) for the prior distribution.}

\item{parameter_name}{Optional character(1). The name of the parameter (or the column with the parameter_name info in
as.priors).}

\item{prior_df}{Optional data.frame. Priors stored as a data.frame or from the results object of a previous run.}

\item{df}{data.frame. Each parameter should be a row and each column is an input into add_prior. If a given column doesn't
relate to a parameter, set its value to NA.}
}
\value{
A priors imabc object.
}
\description{
Helper functions that can be used to create an imabc priors object used by imabc().
}
\section{Distribution Specifications}{

If the user does not provide any RNG functions specifications, they must provide a single value in order to
create a fixed parameter. This is not the most efficient method for using a fixed parameter in a model.

If the user only provides one of the RNG functions specifications, these functions will search for the most logical
names for the other functions. I.e. if dist_base_name is provided (e.g. unif), these will assume that the user wishes
to use paste0("d", dist_base_name) for the density function and paste0("q", dist_base_name) for the quantile function.
These functions will make the corresponding guesses if the user provides density_fn or quantile_fn. If density_fn or
quantile_fn are provided, they will assume those functions are preferred over any calculated function names.
}

\section{RNG Input Specifications}{

These functions will attempt to pass any extra arguments to the RNG functions. These arguments must be named to match
the expected inputs not to create errors. If a value's name cannot be matched to an RNG function input, it will be
ignored.

min/max are important values to imabc and will always be defined for each parameter. They are used to evaluate whether
any simulated parameters are valid. The user can specify values for them if they want. If the user does not specify
them they will look at the RNG function and if the RNG has default values for min/max it will use them, otherwise
it will use -Inf/Inf respectively. \strong{Warning}: This behavior depends on the RNG functions using min and max as the input
names for the min and max values. If the RNG functions use an alternate name for these concepts they will treat
them as separate values. An example of this can be found in the truncnorm package which uses a and b for the min and
max respectively. For those functions the user would need to specify inputs for a, b, min, and max in order to get a
consistent result.
}

\section{Parameter Names}{

The user can specify names by either specifying the input parameter_name in add_prior or by setting the result of an
add_prior call to a object in define_priors (e.g. define_priors(x1 = add_prior(...))). If the user specifies the
parameter_name input and sets add_prior to an object, the parameter_name value will be used. If no name is specified
a unique name will be generated automatically.
}

\examples{
add_prior(dist_base_name = "norm")
add_prior(density_fn = "dnorm", mean = 50, sd = 10)
add_prior(quantile_fn = "qnorm", min = 0, max = 1)

# x1, x2, and x3 reflect three parameters in the mdoel.
x1 <- add_prior(dist_base_name = "norm")
define_priors(
  x1 = x1,
  x2 = add_prior(density_fn = "dnorm", mean = 50, sd = 10),
  add_prior(parameter_name = "x3", quantile_fn = "qnorm", min = 0, max = 1)
)

x1_min <- 0.1
x2_min <- 0.5
x1_max <- 0.9
x2_max <- 1.1
df <- data.frame(
  name_var = c("x1", "x2", "x3"),
  dist_var = c("unif", NA, NA),
  density_var = c(NA, "dtruncnorm", NA),
  quantile_var = c(NA, NA, "qnorm"),
  mean = c(NA, 0.75, 0.5),
  sd = c(NA, 0.05, NA),
  min = c(x1_min, x2_min, NA),
  max = c(x1_max, x2_max, NA),
  a = c(NA, x2_min, NA),
  b = c(NA, x2_max, NA)
)
as.priors(
  df,
  parameter_name = "name_var", dist_base_name = "dist_var",
  density_fn = "density_var", quantile_fn = "quantile_var"
)
}
