% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_data.R
\name{impute_data}
\alias{impute_data}
\title{Impute the data implementing random forest for native corn data.}
\usage{
impute_data(data, useParallel = FALSE)
}
\arguments{
\item{data}{An incomplete dataset that contains qualitative and quantitative
characteristics of a corn or series of corns. The selected characteristics
are related to colors, some measurements, and the locations in which the corn
 was grown. A template for what has to be filled will be included on the
 GitHub page of the project.}

\item{useParallel}{Logical. Perform the analysis in parallel? Defaults to FALSE.}
}
\value{
\code{impute_data()}returns an imputed dataset that can be used with
 \code{find_racialcomplex()}.
}
\description{
Impute and prepare a dataframe to apply the \code{find_racialcomplex()} function,
in case the dataframe has missing values. The imputation is done with random
forests. The database must have the same variables as those in \code{bdMaiz.rds}
in this same package.
}
\examples{
\donttest{
df <- data24[17,]

df_imp <- impute_data(df, useParallel = FALSE)
df_imp
}
}
\references{
Báez Vergara, K. J. Estimación de datos faltantes a través de
redes neuronales, una comparación con métodos simples y múltiples (Doctoral
dissertation, Universidad Santo Tomás).
}
\seealso{
[find_racialcomplex()]
}
\author{
Rafael Nieves-Alvarez (\email{nievesalvarez1618@gmail.com}), Arturo Sanchez-Porras,
 Aline Romero-Natale, Otilio Arturo Acevedo-Sandoval
}
