% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/title_or_id.R
\name{find_by_title}
\alias{find_by_title}
\title{Retrieve OMDB info by title search}
\usage{
find_by_title(title, type = NULL, season = NULL, episode = NULL,
  year_of_release = NULL, plot = "short", include_tomatoes = FALSE,
  api_key = omdb_api_key())
}
\arguments{
\item{title}{Movie title to search for.}

\item{type}{Type of result to return. One of \code{[movie|series|episode|game]}.}

\item{season}{if \code{type} is \code{series} or \code{episode} then it possible
to search within a \code{season} AND \code{epispde} (both required)}

\item{episode}{if \code{type} is \code{series} or \code{episode} then it possible
to search within a \code{season} AND \code{epispde} (both required)}

\item{year_of_release}{Year of release.}

\item{plot}{Return \code{short} or \code{full} plot.}

\item{include_tomatoes}{Include Rotten Tomatoes ratings.}

\item{api_key}{OMDB API key. See \code{\link[=omdb_api_key]{omdb_api_key()}} & \url{https://www.patreon.com/bePatron?u=5038490} for more information.}
}
\value{
\code{tbl_df}/\code{data.frame} of search results (an empty one if none found). Also
classes as an \code{omdb} object for prettier printing
}
\description{
Retrieve OMDB info by title search
}
\note{
The API's search results limit to 10.
}
\seealso{
\href{omdbAPI documentation}{http://www.omdbapi.com/}
}
