% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v0_gene_usage_analysis.R
\name{geneUsageAnalysis}
\alias{geneUsageAnalysis}
\title{Post-analysis of V-gene and J-gene statistics: PCA, clustering, etc.}
\usage{
geneUsageAnalysis(
  .data,
  .method = c("js+hclust", "pca+kmeans", "anova", "js+pca+kmeans"),
  .base = 2,
  .norm.entropy = FALSE,
  .cor = c("pearson", "kendall", "spearman"),
  .do.norm = TRUE,
  .laplace = 1e-12,
  .verbose = TRUE,
  .k = 2,
  .eps = 0.01,
  .perp = 1,
  .theta = 0.1
)
}
\arguments{
\item{.data}{The \code{\link[=geneUsageAnalysis]{geneUsageAnalysis()}} function runs on the output from
\code{\link[=geneUsage]{geneUsage()}}.}

\item{.method}{A string that defines the type of analysis to perform. Can be "pca",
"mds", "js", "kmeans", "hclust", "dbscan" or "cor" if you want to calculate
correlation coefficient. In the latter case you have to provide \code{.cor} argument.}

\item{.base}{A numerical value that defines the logarithm base for Jensen-Shannon
divergence.}

\item{.norm.entropy}{A logical value. Set TRUE to normalise your data if you haven't
done it already.}

\item{.cor}{A string that defines the correlation coefficient for analysis. Can be
"pearson", "kendall" or "spearman".}

\item{.do.norm}{A logical value. If TRUE it forces Laplace smoothing, if NA it checks
if smoothing is necessary, if FALSE does nothing.}

\item{.laplace}{The numeric value, which is used as a pseudocount for Laplace
smoothing.}

\item{.verbose}{A logical value.}

\item{.k}{The number of clusters to create, passed as \code{k} to \link[factoextra:hcut]{hcut} or as \code{centers} to \link{kmeans}.}

\item{.eps}{A numerical value, DBscan epsylon parameter, see
\code{\link[=immunr_dbscan]{immunr_dbscan()}}.}

\item{.perp}{A numerical value, t-SNE perplexity, see \code{\link[=immunr_tsne]{immunr_tsne()}}.}

\item{.theta}{A numerical value, t-SNE theta parameter, see \code{\link[=immunr_tsne]{immunr_tsne()}}.}
}
\value{
Depends on the last element in the \code{.method} string. See \link{immunr_tsne} for more info.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

The \code{\link[=geneUsageAnalysis]{geneUsageAnalysis()}} function deploys several
data analysis methods, including PCA, multidimensional scaling,
Jensen-Shannon divergence, k-means, hierarchical clustering, DBscan, and different
correlation coefficients.
}
\examples{
data(immdata)
gu <- geneUsage(immdata$data, .norm = TRUE)
geneUsageAnalysis(gu, "js+hclust", .verbose = FALSE) \%>\% vis()
}
\concept{gene_usage}
