% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v0_vis.R
\name{vis.clonal_family}
\alias{vis.clonal_family}
\title{Visualise clonal family tree: wrapper for calling on the entire repClonalFamily output}
\usage{
\method{vis}{clonal_family}(.data, ...)
}
\arguments{
\item{.data}{Clonal families from 1 or multiple samples: \code{\link[=repClonalFamily]{repClonalFamily()}} output.}

\item{...}{Not used here.}
}
\value{
A ggraph object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\examples{
\dontrun{
data(bcrdata)
bcr_data <- bcrdata$data

clonal_family <- bcr_data \%>\%
  seqCluster(seqDist(bcr_data), .fixed_threshold = 3) \%>\%
  repGermline(.threads = 1) \%>\%
  repAlignLineage(.min_lineage_sequences = 2, .align_threads = 2, .nofail = TRUE) \%>\%
  repClonalFamily(.threads = 1, .nofail = TRUE) \%>\%
  vis()
}
}
\concept{phylip}
