% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations_external_annotate_seurat.R
\name{annotate_seurat}
\alias{annotate_seurat}
\title{Annotate a Seurat object from ImmunData (by barcode)}
\usage{
annotate_seurat(idata, sdata, cols)
}
\arguments{
\item{idata}{An \link{ImmunData} object.}

\item{sdata}{A Seurat object (cells are columns; barcodes are \code{colnames(sdata)}).}

\item{cols}{Character vector with column names to transfer from \code{idata$annotations}.
Typical choices: \code{"clonal_prop_bin"} or \code{"clonal_rank_bin"}.}
}
\value{
The updated Seurat object with new metadata columns.
}
\description{
Copy selected columns from \code{idata$annotations} to Seurat metadata using
the cell barcode. This is the simplest way to transfer data from \code{immundata}
to Seurat object, e.g., for plotting data on UMAP.
}
\details{
See functions \code{annotate_clonality_rank} and \code{annotate_clonality_prop} in \code{immunarch} package.
}
\examples{
\dontrun{
# After annotating receptors:
idata <- annotate_clonality_prop(idata)

# Transfer the clonality bin to Seurat and plot:
sdata <- annotate_seurat(idata, sdata, cols = "clonal_prop_bin")
Seurat::DimPlot(sdata, reduction = "umap", group.by = "clonal_prop_bin", shuffle = TRUE)

# Alternative: rank bins
idata <- annotate_clonality_rank(idata, bins = c(10, 100))
sdata <- annotate_seurat(idata, sdata, cols = "clonal_rank_bin")
}

}
\seealso{
\link{ImmunData}, \link[SeuratObject:AddMetaData]{SeuratObject::AddMetaData}
}
\concept{Annotation}
