% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_supervised.R
\name{impute_supervised}
\alias{impute_supervised}
\title{Supervised imputation}
\usage{
impute_supervised(
  ds,
  model_spec_parsnip = linear_reg(),
  cols_used_for_imputation = "only_complete",
  cols_order = seq_len(ncol(ds)),
  rows_used_for_imputation = "only_complete",
  rows_order = seq_len(nrow(ds)),
  update_model = "each_column",
  update_ds_model = "each_column",
  M = is.na(ds),
  warn_incomplete_imputation = TRUE,
  ...
)
}
\arguments{
\item{ds}{The data set to be imputed. Must be a data frame with column names.}

\item{model_spec_parsnip}{The model type used for imputation. It is defined
via the \code{parsnip} package.}

\item{cols_used_for_imputation}{Which columns should be used to impute other
columns? Possible choices: "only_complete", "already_imputed", "all"}

\item{cols_order}{Ordering of the columns for imputation. This can be a
vector with indices or an \code{order_option} from \code{\link[=order_cols]{order_cols()}}.}

\item{rows_used_for_imputation}{Which rows should be used to impute other
rows? Possible choices: "only_complete", "partly_complete",
"complete_in_k", "already_imputed", "all_except_i", "all"}

\item{rows_order}{Ordering of the rows for imputation. This can be a vector
with indices or an \code{order_option} from \code{\link[=order_rows]{order_rows()}}.}

\item{update_model}{How often should the model for imputation be updated?
Possible choices are: "everytime" (after every imputed value),
"each_column" (only one update per column) and "every_iteration" (an alias
for "each_column").}

\item{update_ds_model}{How often should the data set for the inner model be
updated? Possible choices are: "everytime" (after every imputed value),
"each_column" (only one update per column) and "every_iteration".}

\item{M}{Missing data indicator matrix}

\item{warn_incomplete_imputation}{Should a warning be given, if the
returned data set still contains \code{NA}?}

\item{...}{Arguments passed on to \code{\link[stats:predict]{stats::predict()}}.}
}
\value{
The imputed data set.
}
\description{
Impute a data set with a supervised inner method. This function is one main
function which can be used inside of \code{\link[=impute_iterative]{impute_iterative()}}. If you need
pre-imputation or iterations, directly use \code{\link[=impute_iterative]{impute_iterative()}}.
}
\details{
This function imputes the columns of the data set \code{ds} column by column. The
imputation order of the columns can be specified by \code{cols_order}.
Furthermore, \code{cols_used_for_imputation} controls which columns are used for
the imputation. The same options are available for the rows of \code{ds} via
\code{rows_order} and \code{rows_used_for_imputation}. If \code{ds} is pre-imputed, the
missing data indicator matrix can be supplied via \code{M}.

The inner method can be specified via \code{model_spec_parsnip} which should be a
parsnip model type like \code{\link[parsnip:linear_reg]{parsnip::linear_reg()}}, \code{\link[parsnip:rand_forest]{parsnip::rand_forest()}}
(for a complete list see \url{https://www.tidymodels.org/find/parsnip}, you can
also build a new parsnip model and use it inside of \code{impute_supervised()},
see \url{https://www.tidymodels.org/learn/develop/models} for more information
on building a parsnip model).

The options "all" for \code{cols_used_for_imputation} and
"all_except_i", "all"  for \code{rows_used_for_imputation} should only be used,
if \code{ds} is complete or the model (\code{model_spec_parsnip}) can handle missing
data.

The choice \code{update_model = "each_column"} can be much faster than
\code{update_model = "everytime"}, especially, if the data set has many
missing values in some columns.
}
\examples{
ds_mis <- missMethods::delete_MCAR(
  data.frame(X = rnorm(20), Y = rnorm(20)), 0.2, 1
)
impute_supervised(ds_mis)
}
