% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleaning.R
\name{cleanData}
\alias{cleanData}
\title{Cleans and prepares data for analysis}
\usage{
cleanData(data, y, treatment, x = NULL, binary = FALSE)
}
\arguments{
\item{data}{A data.frame containing the data to be cleaned.}

\item{y}{Name of the dependent variable (character).}

\item{treatment}{Name of the treatment variable (character, should be logical).}

\item{x}{Names of the covariates to include in the model (character vector, optional).}

\item{binary}{Should the dependent variable be treated as binary? Default is FALSE}
}
\value{
A list containing the cleaned dataset and relevant metadata:
\itemize{
\item \code{N}: The number of observations after cleaning.
\item \code{K} The number of covariates after cleaning.
\item \code{X} The cleaned covariate matrix.
\item \code{treat_vec}: Treatment vector as integers (1 for TRUE, 0 for FALSE).
\item \code{Y}: The dependent variable vector.
}
}
\description{
This function performs a series of data cleaning and preprocessing steps
to ensure the data is suitable for analysis. This includes:
\itemize{
\item Missing data handling
\item Variable type checks
\item Collinearity and zero-variance feature removal
}
}
