% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createData.R
\name{createData}
\alias{createData}
\title{Converts a dataframe into a named list to provide data to a Stan model}
\usage{
createData(
  data,
  y,
  treatment,
  x = NULL,
  eta_mean = 0,
  eta_sd = 1,
  run_estimation = 1
)
}
\arguments{
\item{data}{The data frame to be used}

\item{y}{The name of the outcome variable in the data frame}

\item{treatment}{The name of the treatment indicator variable in the data frame}

\item{x}{A vector of names of all covariates to be used in the data frame}

\item{eta_mean}{The prior mean to be used for estimating the treatment effect}

\item{eta_sd}{The prior standard deviation to be used for estimating the treatment effect}

\item{run_estimation}{Whether to run the estimation, or merely draw data from the priors}
}
\value{
Returns \cr\code{stan_data} a named list providing the data for the stan model
}
\description{
Converts a dataframe into a named list to provide data to a Stan model
}
