% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamic_graph_generators.R
\name{generate.dynamic.network}
\alias{generate.dynamic.network}
\alias{generate.geometric}
\alias{generate.barabasialbert}
\alias{generate.erdosrenyi}
\title{Generate a dynamic network}
\usage{
generate.dynamic.network(
  model, amnt.nodes, amnt.edges, amnt.operations, trace = TRUE, ...)

generate.geometric(
  amnt.nodes,
  amnt.edges,
  amnt.operations,
  amnt.dimensions = 3,
  trace = TRUE
)

generate.barabasialbert(
  amnt.nodes,
  amnt.edges,
  amnt.operations,
  offset.exponent = 1,
  trace = TRUE
)

generate.erdosrenyi(amnt.nodes, amnt.edges, amnt.operations, trace = TRUE)
}
\arguments{
\item{model}{The network model with which to generate the network; \code{"BA"} for Barabási–Albert, \code{"ER"} for Erdős–Rényi, or \code{"GEO"} for geometric}

\item{amnt.nodes}{the number of nodes in the network at any given type}

\item{amnt.edges}{the number of edges in the network at any given type}

\item{amnt.operations}{the number of edge additions/deletions to generate}

\item{trace}{will print output text if \code{TRUE}}

\item{...}{extra parameters to pass to a specific network generator}

\item{amnt.dimensions}{(only GEO) the number of dimensions in which to operate}

\item{offset.exponent}{(only BA) the offset exponent for the weighted sampling}
}
\value{
A list containing the starting network \code{network} and the dynamic operations peformed on it \code{operations}.
}
\description{
Generate a dynamic network
}
\examples{
# dyn.net.ba <- generate.dynamic.network("BA", 300, 300, 1000)
dyn.net.er <- generate.dynamic.network("ER", 300, 300, 1000)
dyn.net.geo <- generate.dynamic.network("GEO", 300, 300, 1000)
}
