% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay.R
\name{DelayedExponential}
\alias{DelayedExponential}
\alias{dexp_delayed}
\alias{pexp_delayed}
\alias{qexp_delayed}
\alias{rexp_delayed}
\alias{mexp_delayed}
\title{Delayed Exponential Distribution}
\usage{
dexp_delayed(
  x,
  delay1 = 0,
  rate1 = 1,
  delay2 = NULL,
  rate2 = NULL,
  delay = delay1,
  rate = rate1,
  log = FALSE
)

pexp_delayed(
  q,
  delay1 = 0,
  rate1 = 1,
  delay2 = NULL,
  rate2 = NULL,
  delay = delay1,
  rate = rate1,
  ...
)

qexp_delayed(
  p,
  delay1 = 0,
  rate1 = 1,
  delay2 = NULL,
  rate2 = NULL,
  delay = delay1,
  rate = rate1,
  lower.tail = TRUE,
  log.p = FALSE
)

rexp_delayed(
  n,
  delay1 = 0,
  rate1 = 1,
  delay2 = NULL,
  rate2 = NULL,
  delay = delay1,
  rate = rate1
)

mexp_delayed(
  t = +Inf,
  delay1 = 0,
  rate1 = 1,
  delay2 = NULL,
  rate2 = NULL,
  delay = delay1,
  rate = rate1
)
}
\arguments{
\item{x}{A numeric vector of values for which to get the density.}

\item{delay1}{numeric. The first delay, must be non-negative.}

\item{rate1}{numeric. The event rate, must be non-negative.}

\item{delay2}{numeric. The second delay, must be non-negative.}

\item{rate2}{numeric. The second event rate, must be non-negative.}

\item{delay}{numeric. Alias for first delay.}

\item{rate}{numeric. Alias for first rate.}

\item{log}{logical. Return value on log-scale?}

\item{q}{A numeric vector of quantile values.}

\item{...}{further arguments are passed on to the underlying non-delayed function, e.g., \verb{lower.tail=} to \code{\link[stats:Exponential]{stats::pexp()}}}

\item{p}{A numeric vector of probabilities.}

\item{lower.tail}{logical. Give cumulative probability of lower tail?}

\item{log.p}{logical. P-value on log-sclae?}

\item{n}{integer. Number of random observations requested.}

\item{t}{A numeric vector of times that restrict the mean survival. Default is \code{+Inf}, i.e., the unrestricted mean survival time.}
}
\value{
Functions pertaining to the delayed exponential distribution:
\itemize{
\item \code{dexp_delayed} gives the density
\item \code{pexp_delayed} gives the distribution function
\item \code{qexp_delayed} gives the quantile function
\item \code{rexp_delayed} generates a pseudo-random sample
\item \code{mexp_delayed} gives the restricted mean survival time
}

The length of the result is determined by \code{n} for \code{rexp_delayed}, and is the maximum of the lengths of the numerical arguments for the other functions,
R's recycling rules apply when only single initial delay phase is used.
}
\description{
Density, distribution function, quantile function, random generation and restricted mean survival time function for the delayed exponential distribution.
There is an initial delay phase (parameter \code{delay1}) where no events occur. After that, \code{rate1} applies.
Optionally, a second phase is possible where the hazard rate might change (parameters \code{delay2} and \code{rate2}).
}
\details{
Additional arguments are forwarded via \code{...} to the underlying functions of the exponential distribution in the \code{stats}-package.
If only a single initial delay phase is there, the numerical arguments other than \code{n} are recycled to the length of the result (as with the exponential distribution in \code{stats}).
With two phases, the arguments are \strong{not} recycled. Only the first element of delays and rates are used as it otherwise becomes ambiguous which delay and rate parameter apply for observations in different phases.
Generally, only the first elements of the logical arguments are used.
}
\seealso{
stats::Exponential
}
\keyword{distribution}
