% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plotDesignPoint}
\alias{plotDesignPoint}
\title{Plot elicited data, fitted marginals or model output}
\usage{
plotDesignPoint(
  Z,
  X = NULL,
  design.pt = NULL,
  elicited.fractiles = TRUE,
  fitted.fractiles = FALSE,
  fitted.curve = FALSE,
  CI.prob = NULL,
  estimated.probs = NULL,
  modelled.fractiles = FALSE,
  modelled.curve = FALSE,
  cumul.prob.bounds = c(0.05, 0.95),
  theta.bounds = NULL,
  ylim.max = NULL,
  xlog = FALSE,
  design.table = TRUE,
  n.pts = 101
)
}
\arguments{
\item{Z}{list object that contains matrix \code{theta} of elicitations,
character \code{link} and character \code{target} as initialised by
\code{\link{designLink}} and updated by \code{\link{elicitPt}}}

\item{X}{design matrix (can be \code{NULL}, unless modelled output is
requested)}

\item{design.pt}{single integer that denotes design point of interest}

\item{elicited.fractiles}{logical, plot vertical lines for elicited 
fractiles?}

\item{fitted.fractiles}{logical, plot vertical lines for fitted conditional
mean prior fractiles for this design point? Alternatively, a numeric vector of arbitrary fractiles to be
plotted from the fitted elicitation distribution. If \code{TRUE} then the
fractiles corresponding to the median, upper and lower level central CI
are plotted}

\item{fitted.curve, }{logical plot fitted conditional mean prior density for this design point?}

\item{CI.prob}{numeric scalar, locally specified probability assigned to the
elicited central credible interval of the current design point. Defaults to
\code{NULL} in which case the global value initially assigned by
\code{\link{designLink}} or as updated by \code{\link{elicitPt}} is used}

\item{estimated.probs}{numeric vector of values for which estimated
probabilities are to be estimated from the fitted elicitation 
distribution for the target theta. Default is \code{NULL}. 
The result is output to the console.}

\item{modelled.fractiles}{logical, plot vertical lines for modelled 
fractiles from the conditional mean prior distribution fit to
all design points? This option requires a design matrix \code{X} of full column rank.}

\item{modelled.curve}{logical, plot modelled conditional mean prior density for
the entire model? This option requires a design matrix \code{X} of full column rank.}

\item{cumul.prob.bounds}{numeric vector of length two, giving plot bounds by 
cumulative probability. This argument is ignored if there is not enough data
to fit a parametric distribution or if \code{theta.bounds} is not \code{NULL}}

\item{theta.bounds}{numeric vector giving support of response for plotting
purposes (can be \code{NULL}). This will overwrite \code{cumul.prob.bounds},
if applicable}

\item{ylim.max}{numeric maximum value of y-axis (can be \code{NULL})}

\item{xlog}{logical log x-axis}

\item{design.table}{logical include design dataframe, elicited fractiles and 
modelled or fitted fractiles}

\item{n.pts}{numeric giving number of point to evalate density curve (if 
plotted)}
}
\value{
a plot to the current device. See \code{dev.cur()} to check.
}
\description{
Plot elicited data, fitted marginals or model output
}
\examples{
# design matrix: two scenarios
X <- matrix(c(1, 1, 0, 1), nrow = 2) 
rownames(X) <- c("scenario1", "scenario2")
colnames(X) <- c("covariate1", "covariate2")

# logit link
# central credible intervals with probability = 1/2
Z <- designLink(design = X, link = "logit", CI.prob = 0.5)

# 1st design point
# no elicited fractiles
indirect::plotDesignPoint(Z, design.pt = 1) 
# elicited median
Z <- indirect::elicitPt(Z, design.pt = 1, 
  lower.CI.bound = NA,
  median = 0.4,
  upper.CI.bound = NA,
  CI.prob = NULL)
indirect::plotDesignPoint(Z, design.pt = 1,   
  elicited.fractiles = TRUE, theta.bounds = c(0, 1))
# lower and upper quartiles and median
Z <- indirect::elicitPt(Z, design.pt = 1, 
  lower.CI.bound = 0.2,
  median = 0.4,
  upper.CI.bound = 0.6,
  comment = "Completed.")
indirect::plotDesignPoint(Z, design.pt = 1,   
  elicited.fractiles = TRUE, theta.bounds = c(0, 1),
  fitted.fractiles = TRUE, fitted.curve = TRUE)
indirect::plotDesignPoint(Z, design.pt = 1,   
  elicited.fractiles = TRUE, theta.bounds = c(0, 1),
  fitted.fractiles = c(1/10, 1/4, 1/2, 3/4, 9/10), 
  fitted.curve = TRUE)   
  
# second design point   
# central credible intervals with probability = 1/3 
# elicit upper and lower tertiles
Z <- elicitPt(Z, design.pt = 2,
  lower.CI.bound = 0.1,
  upper.CI.bound = 0.3,
  CI.prob = 1/3,
  comment = "Switched to tertiles.")
indirect::plotDesignPoint(Z, design.pt = 2,   
  elicited.fractiles = TRUE, theta.bounds = c(0, 1))   
indirect::plotDesignPoint(Z, design.pt = 2,   
  elicited.fractiles = TRUE, theta.bounds = c(0, 1),
  fitted.fractiles = TRUE, fitted.curve = TRUE)
indirect::plotDesignPoint(Z, design.pt = 2,   
  elicited.fractiles = TRUE, theta.bounds = c(0, 1),
  fitted.fractiles = c(1/10, 1/3, 1/2, 2/3, 9/10), 
  fitted.curve = TRUE) 
}
