% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{get_metadata_publications}
\alias{get_metadata_publications}
\title{Get all publications}
\usage{
get_metadata_publications(
  operation = NULL,
  det = 0,
  lang = "ES",
  page = 0,
  validate = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{operation}{(string): code of the operation. Provide code to get all
the publications for the given operation. To obtain a list of
available operations see \code{\link[=get_metadata_operations]{get_metadata_operations()}}.
If no operation is specified then all the publications will be shown.}

\item{det}{(int): level of detail. Valid values: 0, 1 or 2.}

\item{lang}{(string): language of the retrieved data. Set to 'ES' for Spanish or set to 'EN' for English.}

\item{page}{(int): page number. The retrieved result of the query is paginated (page=0 retrieves all pages).}

\item{validate}{(logical): validate input parameters. A FALSE value means fewer API calls.}

\item{verbose}{(logical): print additional information, including the URL to call the API service.}
}
\value{
Data frame with information about publications
}
\description{
Get all publications
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get all publications
df <- get_metadata_publications()
head(df)

# Get publications for a specific operation
df <- get_metadata_publications(operation = "IPC", validate = FALSE)
head(df)
\dontshow{\}) # examplesIf}
}
