test_that("output from ifr_oneway_anova matches the expected output", {
  k <- ifr_oneway_anova(mtcars, mpg, cyl)
  expect_equal(k$ss_between, 824.785)
  expect_equal(k$ss_within, 301.263)
  expect_equal(k$ss_total, 1126.048)
  expect_equal(k$df_btw, 2)
  expect_equal(k$df_within, 29)
  expect_equal(k$df_total, 31)
  expect_equal(k$ms_btw, 412.392)
  expect_equal(k$ms_within, 10.388)
  expect_equal(k$fstat, 39.699)
  expect_equal(k$pval, 0)
  expect_equal(k$r2, 0.7325)
  expect_equal(k$adjusted_r2, 0.714)
  expect_equal(k$rmse, 3.2231)
  expect_equal(k$obs, 32)
})

test_that("output from one way anova is as expected", {
  expect_snapshot(ifr_oneway_anova(mtcars, mpg, cyl))
})
