% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/influxdb_database_management.R
\name{create_database}
\alias{create_database}
\alias{create_database}
\alias{drop_database}
\alias{drop_series}
\alias{delete}
\alias{drop_measurement}
\alias{create_retention_policy}
\alias{alter_retention_policy}
\alias{drop_retention_policy}
\title{Influx database management}
\usage{
create_database(con, db)

drop_database(con, db)

drop_series(con, db, measurement = NULL, where = NULL)

delete(con, db, measurement = NULL, where = NULL)

drop_measurement(con, db, measurement)

create_retention_policy(con, db, rp_name, duration, replication,
  default = FALSE)

alter_retention_policy(con, db, rp_name, duration, replication,
  default = FALSE)

drop_retention_policy(con, db, rp_name)
}
\arguments{
\item{con}{An \code{influx_connection} object (s. \code{\link{influx_connection}}).}

\item{db}{Sets the target database for the query.}

\item{measurement}{Sets a specific measurement.}

\item{where}{Apply filter on tag key values.}

\item{rp_name}{The name of the retention policy.}

\item{duration}{Determines how long InfluxDB keeps the data.}

\item{replication}{The number of data nodes.}

\item{default}{logical. If TRUE, the new retention policy is the default retention policy
for the database.}
}
\value{
A tibble containing post results in case of an error (or message).
Otherwise NULL (invisibly).
}
\description{
The folllowing functions are convenient wrappers around \code{influx_post}.
\itemize{
\item \code{create_database()}: creates a new database
\item \code{drop_database()}: drops an existing database
\item \code{drop_series()}: drops specific series
\item \code{delete()}: deletes all points from a series in a database (supports time intervals)
\item \code{drop_measurement()}: drops an entire measurement
\item \code{create_retention_policy()}: create a new retention policy
\item \code{alter_retention_policy()}: alter a retention policy
\item \code{drop_retention_policy()}: drop a retention policy
}
}
\references{
\url{https://docs.influxdata.com/influxdb/}
}
\seealso{
\code{\link[influxdbr]{influx_connection}}
}
