% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_variable_profile.R
\name{calculate_variable_profile}
\alias{calculate_variable_profile}
\alias{calculate_variable_profile.default}
\title{Internal Function for Individual Variable Profiles}
\usage{
calculate_variable_profile(
  data,
  variable_splits,
  model,
  predict_function = predict,
  ...
)

\method{calculate_variable_profile}{default}(
  data,
  variable_splits,
  model,
  predict_function = predict,
  ...
)
}
\arguments{
\item{data}{set of observations. Profile will be calculated for every observation (every row)}

\item{variable_splits}{named list of vectors. Elements of the list are vectors with points in which profiles should be calculated. See an example for more details.}

\item{model}{a model that will be passed to the \code{predict_function}}

\item{predict_function}{function that takes data and model and returns numeric predictions. Note that the ... arguments will be passed to this function.}

\item{...}{other parameters that will be passed to the \code{predict_function}}
}
\value{
a data frame with profiles for selected variables and selected observations
}
\description{
This function calculates individual variable profiles (ceteris paribus profiles), i.e. series of predictions from a model calculated for observations with altered single coordinate.
}
\details{
Note that \code{\link{calculate_variable_profile}} function is S3 generic.
If you want to work on non standard data sources (like H2O ddf, external databases)
you should overload it.
}
\references{
Explanatory Model Analysis. Explore, Explain, and Examine Predictive Models. \url{https://ema.drwhy.ai/}
}
