% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapper_collect.R
\name{bm_collect}
\alias{bm_collect}
\alias{bru_mapper_collect}
\alias{ibm_n.bm_collect}
\alias{ibm_n_output.bm_collect}
\alias{ibm_values.bm_collect}
\alias{ibm_is_linear.bm_collect}
\alias{ibm_jacobian.bm_collect}
\alias{ibm_eval.bm_collect}
\alias{ibm_linear.bm_collect}
\alias{ibm_invalid_output.bm_collect}
\alias{[.bm_collect}
\alias{[.bru_mapper_collect}
\alias{ibm_names.bm_collect}
\alias{ibm_names<-.bm_collect}
\alias{ibm_names<-.bru_mapper_collect}
\title{Mapper for concatenated variables}
\usage{
bm_collect(mappers, hidden = FALSE)

bru_mapper_collect(...)

\method{ibm_n}{bm_collect}(mapper, inla_f = FALSE, multi = FALSE, ...)

\method{ibm_n_output}{bm_collect}(mapper, input, state = NULL, inla_f = FALSE, multi = FALSE, ...)

\method{ibm_values}{bm_collect}(mapper, inla_f = FALSE, multi = FALSE, ...)

\method{ibm_is_linear}{bm_collect}(mapper, inla_f = FALSE, multi = FALSE, ...)

\method{ibm_jacobian}{bm_collect}(
  mapper,
  input,
  state = NULL,
  inla_f = FALSE,
  multi = FALSE,
  ...,
  sub_lin = NULL
)

\method{ibm_eval}{bm_collect}(
  mapper,
  input,
  state,
  inla_f = FALSE,
  multi = FALSE,
  ...,
  sub_lin = NULL
)

\method{ibm_linear}{bm_collect}(mapper, input, state, inla_f = FALSE, ...)

\method{ibm_invalid_output}{bm_collect}(mapper, input, state, inla_f = FALSE, multi = FALSE, ...)

\method{[}{bm_collect}(x, i, drop = TRUE)

\method{[}{bru_mapper_collect}(x, i, drop = TRUE)

\method{ibm_names}{bm_collect}(mapper)

\method{ibm_names}{bm_collect}(mapper) <- value

\method{ibm_names}{bru_mapper_collect}(mapper) <- value
}
\arguments{
\item{mappers}{A list of \code{bru_mapper} objects}

\item{hidden}{\code{logical}, set to \code{TRUE} to flag that the mapper is to be used
as a first level input mapper for \code{INLA::f()} in a model that requires making
only the first mapper visible to \code{INLA::f()} and \code{INLA::inla.stack()}, such
as for "bym2" models, as activated by the \code{inla_f} argument to \code{ibm_n},
\code{ibm_values}, and \code{ibm_jacobian}. Set to \code{FALSE} to always access the full
mapper, e.g. for \code{rgeneric} models}

\item{...}{Arguments passed on to other methods}

\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{inla_f}{logical; when \code{TRUE} for \code{ibm_n()} and \code{ibm_values()}, the
result must be compatible with the \code{INLA::f(...)} and corresponding
\code{INLA::inla.stack(...)} constructions.  For \verb{ibm_\{eval,jacobian,linear\}},
the \code{input} interpretation may be different.
Implementations do not normally need to do anything different, except
for mappers of the type needed for hidden multicomponent models such
as "bym2", which can be handled by \code{bm_collect}.}

\item{multi}{logical;
If \code{TRUE} (or positive), recurse one level into sub-mappers}

\item{input}{Data input for the mapper.}

\item{state}{A vector of latent state values for the mapping,
of length \code{ibm_n(mapper, inla_f = FALSE)}}

\item{sub_lin}{Internal, optional pre-computed sub-mapper information}

\item{x}{object from which to extract element(s)}

\item{i}{indices specifying element(s) to extract}

\item{drop}{logical;
For \verb{[.bm_collect}, whether to extract an individual mapper when
\code{i} identifies a single element. If \code{FALSE}, a list of sub-mappers is
returned (suitable e.g. for creating a new \code{bm_collect} object).
Default: \code{TRUE}}

\item{value}{a character vector of the same length as the number
of sub-mappers in the mapper}
}
\value{
\itemize{
\item \code{[}-indexing a \code{bm_collect} extracts a subset
\code{bm_collect} object (for drop \code{FALSE}) or an individual sub-mapper
(for drop \code{TRUE}, and \code{i} identifies a single element)
}

\itemize{
\item The \code{names()} method for \code{bm_collect} returns the names from the
sub-mappers list
}
}
\description{
Constructs a concatenated collection mapping
}
\section{Methods (by generic)}{
\itemize{
\item \code{ibm_jacobian(bm_collect)}: Accepts a list with
named entries, or a list with unnamed but ordered elements.
The names must match the sub-mappers, see \code{\link[=ibm_names.bm_collect]{ibm_names.bm_collect()}}.
Each list element should take a format accepted by the corresponding
sub-mapper. In case each element is a vector, the input can be given as a
data.frame with named columns, a matrix with named columns, or a matrix
with unnamed but ordered columns. When \code{inla_f=TRUE} and \code{hidden=TRUE} in
the mapper definition, the input format should instead match that of
the first, non-hidden, sub-mapper.

\item \code{ibm_invalid_output(bm_collect)}: Accepts a list with
named entries, or a list with unnamed but ordered elements.
The names must match the sub-mappers, see \code{\link[=ibm_names.bm_collect]{ibm_names.bm_collect()}}.
Each list element should take a format accepted by the corresponding
sub-mapper. In case each element is a vector, the input can be given as a
data.frame with named columns, a matrix with named columns, or a matrix
with unnamed but ordered columns.

}}
\examples{
(m <- bm_collect(list(
  a = bm_index(2),
  b = bm_index(3)
), hidden = FALSE))
ibm_eval2(m, list(a = c(1, 2), b = c(1, 3, 2)), 1:5)

}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bm_aggregate}()},
\code{\link{bm_const}()},
\code{\link{bm_factor}()},
\code{\link{bm_fmesher}()},
\code{\link{bm_harmonics}()},
\code{\link{bm_index}()},
\code{\link{bm_linear}()},
\code{\link{bm_logsumexp}()},
\code{\link{bm_marginal}()},
\code{\link{bm_matrix}()},
\code{\link{bm_mesh_B}()},
\code{\link{bm_multi}()},
\code{\link{bm_pipe}()},
\code{\link{bm_repeat}()},
\code{\link{bm_scale}()},
\code{\link{bm_shift}()},
\code{\link{bm_sum}()},
\code{\link{bm_taylor}()},
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_generics}}
}
\concept{mappers}
