% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bm_factor}
\alias{bm_factor}
\alias{bru_mapper_factor}
\alias{ibm_n.bm_factor}
\alias{ibm_values.bm_factor}
\alias{ibm_jacobian.bm_factor}
\title{Mapper for factor variables}
\usage{
bm_factor(values, factor_mapping, indexed = FALSE)

bru_mapper_factor(...)

\method{ibm_n}{bm_factor}(mapper, ...)

\method{ibm_values}{bm_factor}(mapper, ...)

\method{ibm_jacobian}{bm_factor}(mapper, input, ...)
}
\arguments{
\item{values}{Input values calculated by \code{\link[=bru_input.bru_input]{bru_input.bru_input()}}}

\item{factor_mapping}{character; selects the type of factor mapping.
\itemize{
\item \code{'contrast'} for leaving out the first factor level.
\item \code{'full'} for keeping all levels.
}}

\item{indexed}{logical; if \code{TRUE}, the \code{ibm_values()} method
will return an integer vector instead of the factor levels.
This is needed e.g. for \code{group} and \code{replicate} mappers, since
\code{INLA::f()} doesn't accept factor values. Default: \code{FALSE}, which
works for the main input mappers. The default mapper constructions
will set it the required setting.}

\item{...}{Arguments passed on to other methods}

\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{input}{Data input for the mapper.}
}
\description{
Create a factor mapper
}
\examples{
m <- bm_factor(factor(c("a", "b")), "full")
ibm_eval2(m, input = c("b", "a", "a", "b"), state = c(1, 3))

m <- bm_factor(factor(c("a", "b")), "contrast")
ibm_eval2(m, input = factor(c("b", "a", "a", "b")), state = 2)

}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bm_aggregate}()},
\code{\link{bm_collect}()},
\code{\link{bm_const}()},
\code{\link{bm_fmesher}()},
\code{\link{bm_harmonics}()},
\code{\link{bm_index}()},
\code{\link{bm_linear}()},
\code{\link{bm_logsumexp}()},
\code{\link{bm_marginal}()},
\code{\link{bm_matrix}()},
\code{\link{bm_mesh_B}()},
\code{\link{bm_multi}()},
\code{\link{bm_pipe}()},
\code{\link{bm_repeat}()},
\code{\link{bm_scale}()},
\code{\link{bm_shift}()},
\code{\link{bm_sum}()},
\code{\link{bm_taylor}()},
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_generics}}
}
\concept{mappers}
