% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spde.R
\name{spde.posterior}
\alias{spde.posterior}
\title{Posteriors of SPDE hyper parameters and Matern correlation or
covariance function.}
\usage{
spde.posterior(result, name, what = "range", quantile = 0.95)
}
\arguments{
\item{result}{An object inheriting from \code{inla}.}

\item{name}{Character stating the name of the SPDE effect, see
\code{names(result$summary.random)}.}

\item{what}{One of "range", "log.range", "variance", "log.variance",
"matern.correlation" or "matern.covariance".}

\item{quantile}{The target credible probability. Default 0.95.}
}
\value{
A \code{prediction} object.
}
\description{
Calculate posterior distribution of the range, log(range), variance, or
log(variance) parameter of a model's SPDE component. Can also plot Matern
correlation or covariance function. \code{inla.spde.result}.
}
\examples{
\donttest{
if (bru_safe_inla() && require(ggplot2, quietly = TRUE)) {

  # Load 1D Poisson process data

  data(Poisson2_1D, package = "inlabru")


  # Take a look at the point (and frequency) data

  ggplot(pts2) +
    geom_histogram(aes(x = x), binwidth = 55 / 20, boundary = 0, fill = NA, color = "black") +
    geom_point(aes(x), y = 0, pch = "|", cex = 4) +
    coord_fixed(ratio = 1)

  # Fit an LGCP model with  and SPDE component

  x <- seq(0, 55, length.out = 20)
  mesh1D <- fm_mesh_1d(x, boundary = "free")
  mdl <- x ~ spde1D(x, model = INLA::inla.spde2.matern(mesh1D, constr = TRUE)) + Intercept(1)
  fit <- lgcp(mdl, data = pts2, domain = list(x = mesh1D))

  # Calculate and plot the posterior range

  range <- spde.posterior(fit, "spde1D", "range")
  plot(range)

  # Calculate and plot the posterior log range

  lrange <- spde.posterior(fit, "spde1D", "log.range")
  plot(lrange)

  # Calculate and plot the posterior variance

  variance <- spde.posterior(fit, "spde1D", "variance")
  plot(variance)

  # Calculate and plot the posterior log variance

  lvariance <- spde.posterior(fit, "spde1D", "log.variance")
  plot(lvariance)

  # Calculate and plot the posterior Matern correlation

  matcor <- spde.posterior(fit, "spde1D", "matern.correlation")
  plot(matcor)

  # Calculate and plot the posterior Matern covariance

  matcov <- spde.posterior(fit, "spde1D", "matern.covariance")
  plot(matcov)
}
}
}
\author{
Finn Lindgren \email{Finn.Lindgren@ed.ac.uk}
}
