% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{show_data_structure}
\alias{show_data_structure}
\title{Visualize the model data structure as matrices in LaTeX}
\usage{
show_data_structure(stack)
}
\arguments{
\item{stack}{an object of class inla.stack returned from the function make_inlamemi_stacks, which describes the structure of the data for the measurement error and imputation model.}
}
\value{
A list containing data frames with the left hand side (response_df) and right hand side (effects_df), along with the latex code needed to visualize the matrices (matrix_string).
}
\description{
Visualize the model data structure as matrices in LaTeX
}
\examples{
\dontshow{if (requireNamespace('INLA')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
stack <- make_inlamemi_stacks(data = simple_data,
                   formula_moi = y ~ x + z,
                   formula_imp = x ~ z,
                   error_type = "classical")
show_data_structure(stack)
\dontshow{\}) # examplesIf}
}
