% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DroppingInterval.R
\name{anova.intRvals}
\alias{anova.intRvals}
\title{Compares model fits of \code{intRvals} objects}
\usage{
\method{anova}{intRvals}(
  object,
  y = NULL,
  conf.level = 0.95,
  digits = max(3L, getOption("digits") - 3L),
  ...
)
}
\arguments{
\item{object}{an object of class \code{intRvals}, usually a result of a call to \link[intRvals]{estinterval}}

\item{y}{an (optional) object of class \code{intRvals}, usually a result of a call to \link[intRvals]{estinterval}}

\item{conf.level}{confidence level for the deviance test}

\item{digits}{the number of digits for printing to screen}

\item{...}{other arguments to be passed to low level functions}
}
\value{
A list of class "\code{anova.intRvals}" with the best model (1 or 2), deviance statistic and test results
\describe{
  \item{\code{best.model}}{the index of the best model (1 is first argument, 2 is second)}
  \item{\code{deviance}}{the deviance between the two tested models}
  \item{\code{p.value}}{p-value for the deviance (likelihood-ratio) test}
  \item{\code{conf.level}}{assumed confidence level for the test}
  \item{\code{model1.call}}{call that generated model 1}
  \item{\code{model2.call}}{call that generated model 2}
  \item{\code{AIC}}{numeric 2-vector containg the AIC value for model 1 (first element) and model 2 (second element)}
  \item{\code{loglik}}{numeric 2-vector containg the log-likelihood value for model 1 (first element) and model 2 (second element)}
}
}
\description{
Compare model fits of \code{intRvals} objects estimated on the same data.
If one object is provided, the results of a deviance test against a model without a missed event probability 'p'
is reported. If two objects are provided, the results of a deviance test between the model fits of the two objects is given.
}
\examples{
data(goosedrop)
model1=estinterval(goosedrop$interval,fun="gamma")
# visually inspect model1 fit:
plot(model1)
# The observed distribution has intervals near zero.
# We allow a small random baseline to reduce the effect
# of intervals near zero on the fit result.
model2=estinterval(goosedrop$interval,fun="gamma",fpp.method='auto')
# model2 performs better than model1:
anova(model1,model2)
}
