% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputFunctions.R
\name{igToPS}
\alias{igToPS}
\title{Exports Interaction graph to a PS (PostScript) file}
\usage{
igToPS(ig, path = "", fName = "InteractionGraph", h = 2000)
}
\arguments{
\item{ig}{Interaction graph}

\item{path}{The folder in which to write the PS file;}

\item{fName}{The name of the file to be created; "InteractionGraph" by
default}

\item{h}{Desired height of the image in pixels; 2000px by default}
}
\value{
Writes the \code{ig} interaction graph to a PostScript (\code{.ps})
  file to the folder specified in the \code{path}
}
\description{
Exports Interaction graph to a PS (PostScript) file
}
\examples{
\donttest{
#create temp dir path with slashes
myDir <- gsub("\\\\\\\\", "/", tempdir())

#create interaction graph
g <- interactionGraph(golf, "Play", intNo = 10)

#write to PS
igToPS(g, path = myDir, fName = "MyGraph", h = 2000) }
}
