% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intensitynet.R
\name{PathTotalWeight}
\alias{PathTotalWeight}
\alias{PathTotalWeight.intensitynet}
\title{Calculates the total weight of the given path}
\usage{
PathTotalWeight(obj, path_nodes, weight = NA)

\method{PathTotalWeight}{intensitynet}(obj, path_nodes, weight = NA)
}
\arguments{
\item{obj}{intensitynet object}

\item{path_nodes}{vector containing the node ID's of the path}

\item{weight}{an string specifying the type of weight to be computed. If no weight type is provided,
the function will calculate the total amount of edges. Default NA.}
}
\value{
total weight of the path
}
\description{
Calculates the total weight of the given path
}
\examples{

data("und_intnet_chicago")
PathTotalWeight(und_intnet_chicago, c('V115', 'V123', 'V125', 'V134'), weight = 'intensity')

}
