% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interim.r
\name{event}
\alias{event}
\title{Scheduling interim analyses in clinical trials for time-to-event settings}
\usage{
event(r, er, dr, du)
}
\arguments{
\item{r}{recruitment scenario calculated with function \code{recruitment}.}

\item{er}{event rate during the clinical trail.}

\item{dr}{drop-out rate during the clinical trail.}

\item{du}{duration of the clinical trail in weeks.}
}
\value{
\itemize{
\item \code{event} returns a list of vectors with the following components:
\item \code{events} a vector with the (cumulative) number of frist events (events before drop-out)
\item \code{drops} a vector with the (cumulative) number of patients who droped out of the trail before the first event
\item \code{weeksOfEvent} a vector with the corresponding trial week when patients have experienced the first event
(with start of site openings as reference start)
}
}
\description{
Function \code{event} simulates the events base on a recruitment scenario simulated by function \code{recruitment}.
}
\details{
\code{event} simulates the events based on a given recruitment scenario.
The function assumes an exponential distribution for the event probability with a common event rate for all subjects (\code{er}).
The drop-out rate may be included. For the probability of an drop-out, \code{treatment} assumes an exponential distribution with a common rate \code{dr}.
It is assumed that the even and drop-out time are independent of each other.
}
\examples{
x=recruitment(nc=Inf,ns=Inf,cw=4,sw=2,sf=0.3,tb=4,en=400)
y=event(r=x,er=0.12,dr=0.08,du=50)

x=recruitment(nc=Inf,ns=Inf,cw=4,sw=2,sf=0.3,tb=4,en=400)
y=event(r=x,er=0.12,dr=0.08,du=50)
}
\seealso{
\code{\link{recruitment}} for simulating recruitment scenarios;
\code{\link{eventCourse}} for plots of recruitment and event scenarios;
}
