% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propCI.R
\name{propCI_sub}
\alias{propCI_sub}
\title{Calculate confidence intervals of proportion or difference between proportions in a data.frame}
\usage{
propCI_sub(data, x, y = NULL)
}
\arguments{
\item{data}{A data.frame}

\item{x}{Character Name of a categorical column}

\item{y}{Character Optional. Name of another categorical column}
}
\value{
A list containing at least the following components:
\describe{
  \item{data}{A tibble containing raw data or a list of numeric vector}
  \item{result}{A data.frame consists of summary statistics}
  \item{call}{the matched call}
  \item{attr(*,"measure")}{character. One of c("prop","propdiff")}
}
}
\description{
Calculate confidence intervals of proportion or difference between proportions in a data.frame
}
\examples{
propCI_sub(acs,"sex")
propCI_sub(acs,"sex","HBP")
}
