% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation_functions.R
\name{inv_ilr}
\alias{inv_ilr}
\alias{inv_slr}
\title{Inverse Log-Ratio transformations for interval responses}
\usage{
inv_ilr(bvn)

inv_slr(bvn)
}
\arguments{
\item{bvn}{A numeric vector containing an unbounded interval location and width or
a dataframe where each of the rows consists of such a vector.}
}
\value{
A numeric vector containing a 2-simplex or a dataframe where each of
the rows consists of such a vector.
}
\description{
Transform unbounded data back to the simplex space using either Isometric Log-Ratio (ILR)
or Sum Log-Ratio (SLR) inverse transformations, as described by Smithson & Broomell (2024).
These transformations are the inverse transformations of \code{\link[=ilr]{ilr()}} and \code{\link[=slr]{slr()}}.

\strong{Inverse ILR}

The inverse ILR transformation equations are:
\deqn{x_1 = \frac{\exp(\sqrt{2} x_{loc})}{\exp(\sqrt{2} x_{loc}) + \exp(\sqrt{\frac{3}{2}} x_{wid} + \frac{x_{loc}}{\sqrt{2}}) + 1}}
\deqn{x_2 = \frac{\exp(\sqrt{\frac{3}{2}} x_{wid} + \frac{x_{loc}}{\sqrt{2}})}{\exp(\sqrt{2} x_{loc}) + \exp(\sqrt{\frac{3}{2}} x_{wid} + \frac{x_{loc}}{\sqrt{2}}) + 1}}
\deqn{x_3 = \frac{1}{\exp(\sqrt{2} x_{loc}) + \exp(\sqrt{\frac{3}{2}} x_{wid} + \frac{x_{loc}}{\sqrt{2}}) + 1}}

\strong{Inverse SLR}

The inverse SLR transformation equations are:
\deqn{x_1 = \frac{\exp(x_{loc})}{(\exp(x_{loc}) + 1)(\exp(x_{wid}) + 1)}}
\deqn{x_2 = \frac{\exp(x_{wid})}{\exp(x_{wid}) + 1}}
\deqn{x_3 = \frac{1}{(\exp(x_{loc}) + 1)(\exp(x_{wid}) + 1)}}

where \eqn{(x_{loc}, x_{wid})} are the unbounded interval location and width
and \eqn{(x_1, x_2, x_3)} is the resulting interval response in the simplex format.
}
\examples{
# Generate some unbounded data
bvn <- data.frame(rbind(c(0, .2), c(-2, .4)))

# Inverse ILR transformation
inv_ilr(bvn)

# Inverse SLR transformation
inv_slr(bvn)


}
\references{
Smithson, M., & Broomell, S. B. (2024). Compositional data analysis tutorial. Psychological Methods, 29(2), 362–378.
}
\seealso{
\code{\link[=ilr]{ilr()}}, \code{\link[=slr]{slr()}}
}
