% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intmap.R
\name{intmap}
\alias{intmap}
\title{R6 class representing an ordered map}
\description{
A map is given by keys and values.
}
\examples{

## ------------------------------------------------
## Method `intmap$new`
## ------------------------------------------------

intmap$new() # empty map
intmap$new(
  keys = c(4, -2), 
  values = list(c(1, 2), c("a", "b", "c"))
)
# examples with duplicated keys:
intmap$new(
  keys = c(1, 1, 5), 
  values = list(c(1, 2), c(3, 4), "x")
)

## ------------------------------------------------
## Method `intmap$size`
## ------------------------------------------------

imap <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap$size()

## ------------------------------------------------
## Method `intmap$keys`
## ------------------------------------------------

imap <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap$keys()

## ------------------------------------------------
## Method `intmap$values`
## ------------------------------------------------

imap <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap$values()

## ------------------------------------------------
## Method `intmap$items`
## ------------------------------------------------

imap <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap$items()

## ------------------------------------------------
## Method `intmap$toList`
## ------------------------------------------------

imap <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap$toList()

## ------------------------------------------------
## Method `intmap$at`
## ------------------------------------------------

imap <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap$at(11)
from_just(imap$at(11))
imap$at(4)

## ------------------------------------------------
## Method `intmap$get`
## ------------------------------------------------

imap <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap$get(11, default = 999)
imap$get(4, default = 999)

## ------------------------------------------------
## Method `intmap$index`
## ------------------------------------------------

imap <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap$index(11)
imap$index(4)

## ------------------------------------------------
## Method `intmap$extract`
## ------------------------------------------------

imap <- intmap$new(
  keys = c(11, -2, 3), values = list(c("a", "b"), list(3, 4, 5), "X")
)
imap_copy <- imap$copy()
imap$extract(c(11, 3))
imap
imap$extract(c(11, 3), inplace = TRUE)
imap
imap_copy$extract(c(11, 3), bydeleting = TRUE)
imap_copy
imap_copy$extract(c(11, 3), inplace = TRUE, bydeleting = TRUE)
imap_copy

## ------------------------------------------------
## Method `intmap$has_key`
## ------------------------------------------------

imap <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap$has_key(11)
imap$has_key(1)

## ------------------------------------------------
## Method `intmap$nth`
## ------------------------------------------------

imap <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap$nth(2)
imap$nth(2, stop_if_too_large = FALSE)
imap$nth(9, stop_if_too_large = FALSE)

## ------------------------------------------------
## Method `intmap$insert`
## ------------------------------------------------

imap <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap$insert(3, c(6, 7)) # TRUE (insertion)
imap
imap$insert(11, c(8, 9)) # FALSE (no change)
imap
imap$insert(11, c(8, 9), replace = TRUE) # FALSE (replacement)
imap

## ------------------------------------------------
## Method `intmap$erase`
## ------------------------------------------------

imap <- intmap$new(
  keys = c(11, -2, 3), values = list(c("a", "b"), list(3, 4, 5), "X")
)
imap$erase(11)
imap
imap$erase(c(-2, 3))
imap

## ------------------------------------------------
## Method `intmap$merge`
## ------------------------------------------------

imap1 <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap2 <- intmap$new(
  keys = c(11, 3), values = list("X", "Z")
)
imap1$merge(imap2)
imap1

## ------------------------------------------------
## Method `intmap$copy`
## ------------------------------------------------

imap <- intmap$new(
  keys = c(11, 3), values = list(TRUE, "Z")
)
true_copy <- imap$copy()
true_copy$erase(11)
imap
naive_copy <- imap
naive_copy$erase(11)
imap
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-intmap-new}{\code{intmap$new()}}
\item \href{#method-intmap-print}{\code{intmap$print()}}
\item \href{#method-intmap-size}{\code{intmap$size()}}
\item \href{#method-intmap-keys}{\code{intmap$keys()}}
\item \href{#method-intmap-values}{\code{intmap$values()}}
\item \href{#method-intmap-items}{\code{intmap$items()}}
\item \href{#method-intmap-toList}{\code{intmap$toList()}}
\item \href{#method-intmap-at}{\code{intmap$at()}}
\item \href{#method-intmap-get}{\code{intmap$get()}}
\item \href{#method-intmap-index}{\code{intmap$index()}}
\item \href{#method-intmap-extract}{\code{intmap$extract()}}
\item \href{#method-intmap-has_key}{\code{intmap$has_key()}}
\item \href{#method-intmap-nth}{\code{intmap$nth()}}
\item \href{#method-intmap-insert}{\code{intmap$insert()}}
\item \href{#method-intmap-erase}{\code{intmap$erase()}}
\item \href{#method-intmap-merge}{\code{intmap$merge()}}
\item \href{#method-intmap-copy}{\code{intmap$copy()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-intmap-new"></a>}}
\if{latex}{\out{\hypertarget{method-intmap-new}{}}}
\subsection{Method \code{new()}}{
Creates a new \code{intmap} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{intmap$new(keys = NULL, values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keys}}{keys, an integer vector without \code{NA} value}

\item{\code{values}}{values, a list of R objects; \code{keys} and 
\code{values} must have the same length}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{intmap} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{intmap$new() # empty map
intmap$new(
  keys = c(4, -2), 
  values = list(c(1, 2), c("a", "b", "c"))
)
# examples with duplicated keys:
intmap$new(
  keys = c(1, 1, 5), 
  values = list(c(1, 2), c(3, 4), "x")
)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-intmap-print"></a>}}
\if{latex}{\out{\hypertarget{method-intmap-print}{}}}
\subsection{Method \code{print()}}{
Show instance of an \code{intmap} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{intmap$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-intmap-size"></a>}}
\if{latex}{\out{\hypertarget{method-intmap-size}{}}}
\subsection{Method \code{size()}}{
Size of the reference map.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{intmap$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
An integer, the number of entries.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{imap <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap$size()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-intmap-keys"></a>}}
\if{latex}{\out{\hypertarget{method-intmap-keys}{}}}
\subsection{Method \code{keys()}}{
Get all keys.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{intmap$keys()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The keys, an integer vector.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{imap <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap$keys()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-intmap-values"></a>}}
\if{latex}{\out{\hypertarget{method-intmap-values}{}}}
\subsection{Method \code{values()}}{
Get all values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{intmap$values()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The values, a list of R objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{imap <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap$values()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-intmap-items"></a>}}
\if{latex}{\out{\hypertarget{method-intmap-items}{}}}
\subsection{Method \code{items()}}{
Get all entries of the reference map.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{intmap$items()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The entries in a dataframe.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{imap <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap$items()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-intmap-toList"></a>}}
\if{latex}{\out{\hypertarget{method-intmap-toList}{}}}
\subsection{Method \code{toList()}}{
Converts the map to a named list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{intmap$toList()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A named list (the names are the keys).
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{imap <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap$toList()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-intmap-at"></a>}}
\if{latex}{\out{\hypertarget{method-intmap-at}{}}}
\subsection{Method \code{at()}}{
Returns the 'maybe' value corresponding to the given key.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{intmap$at(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{a key (integer)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{maybe} value, either the value corresponding to the key 
  as a 'Just' \code{maybe} value if the key is found, otherwise the 
  'Nothing' \code{maybe} value.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{imap <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap$at(11)
from_just(imap$at(11))
imap$at(4)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-intmap-get"></a>}}
\if{latex}{\out{\hypertarget{method-intmap-get}{}}}
\subsection{Method \code{get()}}{
Get the value corresponding to the given key or a default 
  value if this key is missing.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{intmap$get(key, default = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{a key (integer)}

\item{\code{default}}{a R object, the default value}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Either the value corresponding to the key if the key is found, 
  otherwise the \code{default} value.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{imap <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap$get(11, default = 999)
imap$get(4, default = 999)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-intmap-index"></a>}}
\if{latex}{\out{\hypertarget{method-intmap-index}{}}}
\subsection{Method \code{index()}}{
Returns the index of the given key.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{intmap$index(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{a key (integer)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The index of the key, or \code{NA} if it is not found.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{imap <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap$index(11)
imap$index(4)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-intmap-extract"></a>}}
\if{latex}{\out{\hypertarget{method-intmap-extract}{}}}
\subsection{Method \code{extract()}}{
Extract a submap from the reference map.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{intmap$extract(keys, inplace = FALSE, bydeleting = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keys}}{some keys, an integer vector; those which do not belong to 
the keys of the reference map will be ignored}

\item{\code{inplace}}{Boolean, whether to update the reference map or 
to return a new map}

\item{\code{bydeleting}}{Boolean, whether to construct the submap by 
deleting the keys which are not in \code{keys} or by starting 
from the empty submap and adding the entries}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{intmap} object if \code{inplace=FALSE}, 
  otherwise the updated reference map, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{imap <- intmap$new(
  keys = c(11, -2, 3), values = list(c("a", "b"), list(3, 4, 5), "X")
)
imap_copy <- imap$copy()
imap$extract(c(11, 3))
imap
imap$extract(c(11, 3), inplace = TRUE)
imap
imap_copy$extract(c(11, 3), bydeleting = TRUE)
imap_copy
imap_copy$extract(c(11, 3), inplace = TRUE, bydeleting = TRUE)
imap_copy
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-intmap-has_key"></a>}}
\if{latex}{\out{\hypertarget{method-intmap-has_key}{}}}
\subsection{Method \code{has_key()}}{
Checks whether a key exists in the reference map.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{intmap$has_key(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{a key (integer)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Boolean value.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{imap <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap$has_key(11)
imap$has_key(1)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-intmap-nth"></a>}}
\if{latex}{\out{\hypertarget{method-intmap-nth}{}}}
\subsection{Method \code{nth()}}{
Returns the n-th entry of the reference map.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{intmap$nth(n, stop_if_too_large = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{index, a positive integer}

\item{\code{stop_if_too_large}}{a Boolean value, whether to stop if \code{n}
is too large, or to use \code{maybe} values}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list with the key and the value at index \code{n} if 
  \code{stop_if_too_large=TRUE} and \code{n} is not too large, otherwise 
  a \code{maybe} value: either this list wrapped in a 'Just' container, 
  or 'Nothing'.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{imap <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap$nth(2)
imap$nth(2, stop_if_too_large = FALSE)
imap$nth(9, stop_if_too_large = FALSE)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-intmap-insert"></a>}}
\if{latex}{\out{\hypertarget{method-intmap-insert}{}}}
\subsection{Method \code{insert()}}{
Insert a new entry in the reference map.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{intmap$insert(key, value, replace = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{a key (integer)}

\item{\code{value}}{a value (R object)}

\item{\code{replace}}{Boolean, whether to replace the value if the key is 
already present}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This updates the reference map and this returns a Boolean value:
  if \code{replace=FALSE}, this returns \code{TRUE} if the value has 
  been inserted (i.e. the given key is new); similarly, if 
  \code{replace=TRUE}, this returns \code{TRUE} if the given key is new 
  (so \code{FALSE} means that the value of the existing key has been 
  replaced).
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{imap <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap$insert(3, c(6, 7)) # TRUE (insertion)
imap
imap$insert(11, c(8, 9)) # FALSE (no change)
imap
imap$insert(11, c(8, 9), replace = TRUE) # FALSE (replacement)
imap
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-intmap-erase"></a>}}
\if{latex}{\out{\hypertarget{method-intmap-erase}{}}}
\subsection{Method \code{erase()}}{
Erase the entries of the reference map whose keys are the 
  given ones.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{intmap$erase(keys)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keys}}{some keys, an integer vector; those which do not belong to
the keys of the reference map are ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The reference map, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{imap <- intmap$new(
  keys = c(11, -2, 3), values = list(c("a", "b"), list(3, 4, 5), "X")
)
imap$erase(11)
imap
imap$erase(c(-2, 3))
imap
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-intmap-merge"></a>}}
\if{latex}{\out{\hypertarget{method-intmap-merge}{}}}
\subsection{Method \code{merge()}}{
Merge the reference map with another map.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{intmap$merge(map)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{map}}{an \code{intmap} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The updated reference map, invisibly. Keys of \code{map} that 
  are also keys of the reference map are ignored, i.e. there is no 
  replacement, only insertions.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{imap1 <- intmap$new(
  keys = c(11, -2), values = list(c("a", "b"), list(3, 4, 5))
)
imap2 <- intmap$new(
  keys = c(11, 3), values = list("X", "Z")
)
imap1$merge(imap2)
imap1
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-intmap-copy"></a>}}
\if{latex}{\out{\hypertarget{method-intmap-copy}{}}}
\subsection{Method \code{copy()}}{
Copy the reference map.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{intmap$copy()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A copy of the reference map.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{imap <- intmap$new(
  keys = c(11, 3), values = list(TRUE, "Z")
)
true_copy <- imap$copy()
true_copy$erase(11)
imap
naive_copy <- imap
naive_copy$erase(11)
imap
}
\if{html}{\out{</div>}}

}

}
}
