% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/possible_markdowns.R
\name{possible_markdowns}
\alias{possible_markdowns}
\title{possible_markdowns}
\usage{
possible_markdowns(
  begining_inventory,
  weeks,
  current_week,
  inventory_at_week,
  expected_at_season_end,
  plot = TRUE
)
}
\arguments{
\item{begining_inventory, }{inventory at the beginning of the season before selling.}

\item{weeks, }{number of weeks in the season.}

\item{current_week, }{the end of the current week.}

\item{inventory_at_week, }{inventory at the end of the current week.}

\item{expected_at_season_end, }{expected inventory left for salvage or writing off at the end of the season, if the forecast is
below it, then it becomes a regular item if the forecast is higher than expected at season end then it becomes a slow moving item.}

\item{plot}{Default is false,if true, a plot is generated}
}
\value{
a dataframe that contains all tthe possible economically viable markdowns.
}
\description{
a markdown model 
This is a markdown model proposed in
Walker, John. "A model for determining price markdowns of seasonal merchandise." 
Journal of Product & Brand Management (1999), the idea that it is possible for seasonal merchandise to forecast how much
for a specific product can be left at the end of the season. based on the sales rate in the periods of the selling season.
for example, if a seasonal shirt initial buying quantity is 500, during the the first two weeks we sold 100 and the season for this
shirt is 6 weeks, then it is possible to forecast for a one time shot product how much is expected to be left with at the end of the 
season (at the end of the 6 weeks), the function applies the algorithm in walker (1999), the returning value is a classification of
the item if it is a slow moving or a regular item. also the possible markdowns that can be applied.
(only markdowns where there is a economic viability) and this can be a dynamic markdown process where the process can be repeated
every week, preferably when the product changes its status from Regular to slow moving. if the markdown recommendation is for example 
0.9 then it means that the new price is 90 % of the original price. and so on for the following week, hence the dynamic process.
}
\examples{
possible_markdowns(begining_inventory=1000,weeks=16,
current_week=2,inventory_at_week=825,expected_at_season_end=150,plot=TRUE)
}
\author{
"haytham omar  email: <haytham@rescaleanalytics.com>"
}
