% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_methods_nca.R
\name{nca.pk}
\alias{nca.pk}
\title{NCA for a `pk` object}
\usage{
\method{nca}{pk}(
  obj,
  newdata = NULL,
  nca_group = NULL,
  exclude = TRUE,
  dose_norm = FALSE,
  suppress.messages = NULL,
  ...
)
}
\arguments{
\item{obj}{A [pk()] model object. Must be fitted, or the function will exit
with an error.}

\item{newdata}{Optional: A `data.frame` containing new data for which to
compute the TK stats. Must contain at least variables `Chemical`,
`Species`, `Route`, `Dose`, `Conc`, `Dose.Units`, `Conc.Units`, and
`Time.Units`, and any other variables named in
`tk_grouping`. Default `NULL`, to use the data in `get_data(obj)`.}

\item{nca_group}{A list of variables provided using a `dplyr::vars()` call.
The data (either `newdata` or `obj$data`) will be grouped according to the
unique combinations of these variables. For each unique combination of
these variables in the data, a set of TK statistics will be computed. The
default is `NULL`, to use the same data grouping that was set in
[stat_nca_group()] for the `pk` object. However, you may specify a different data
grouping if you wish.}

\item{exclude}{Logical: `TRUE` to group the data for NCA after removing any
observations in the data marked for exclusion (if there is a variable
`exclude` in the data, an observation is marked for exclusion when `exclude
%in% TRUE`). `FALSE` to include all observations when grouping the data for
NCA, regardless of exclusion status. Default `TRUE`.}

\item{dose_norm}{Logical: `TRUE` to perform NCA after dose-normalizing
concentrations. `FALSE` (default) to perform NCA on un-transformed
concentrations.}

\item{suppress.messages}{Logical: whether to suppress message printing. If
NULL (default), uses the setting in
`obj$pk_settings$preprocess$suppress.messages`}

\item{...}{Additional arguments. Currently not in use.}
}
\value{
A `data.frame` with variables including all the grouping variables in
  `nca_group`, `nca_group_id`; `design` (the auto-detected study design for
  this group); `param_name` (the name of the NCA parameter); `param_value`
  (the NCA parameter value); `param_sd_z` (standard deviation of the
  estimated NCA parameter value, if available); `param_units` (the units of
  the NCA parameter, derived from the units of the data).
}
\description{
Non-compartmental analysis for a `pk` object
}
\details{
Perform non-compartmental analysis of data in a `pk` object (or optionally,
new data), using data groupings defined by `get_nca_group()` for the `pk`
object (or optionally, new groupings). If you provide both `newdata` and
`nca_group`, then everything in the `pk` object will be ignored and you will
simply be doing NCA *de novo* (which may be what you want).
}
\author{
Caroline Ring
}
