% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{utilityShp}
\alias{utilityShp}
\title{Schmidt-Hunter-Pearlman Utility Model.}
\usage{
utilityShp(n = 1, sdy, d, cost = 0, period = 1)
}
\arguments{
\item{n}{The number of employees involved in the intervention.}

\item{sdy}{The standard deviation of performance in monetary units.}

\item{d}{The difference in job performance between the group recieving a 
treatment and the group not recieving a treatment, expressed in
standard deviation units.}

\item{cost}{The cost of the intervention per participant.}

\item{period}{The anticipate duration of the training effect.}
}
\value{
Estimated gain in utility.
}
\description{
This model calculates the utility of an intervention accepting d rather
than rxy as an argument.
}
\examples{
utilityShp(sdy=10000, d=.50, period=4)
}
\author{
Allen Goebl and Jeff Jones
}
\references{
Schmidt, F. L., Hunter, J. E., & Pearlman, K. (1982). Assessing
  the economic impact of personnel programs on workforce productivity.
  \emph{Personnel Psychology}, 35(2), 333-347.
}

