% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vector_transpose.R
\name{key_column_create}
\alias{key_column_create}
\title{Create a key columnn}
\usage{
key_column_create(key_column_name, key_column_values = NULL)
}
\arguments{
\item{key_column_name}{The name of the key column.}

\item{key_column_values}{The value(s) of the key column}
}
\value{
A tibble with one column, named \code{key_column_name} and with values \code{key_column_values}.
}
\description{
Create a key column for matching the dimensions of matrixes.
}
\details{
This function will likely be used with the creation of coefficients that need to be matched with
a matrix that has a key column.
}
\examples{
key_column_create("iotables_row", c("CO2_multiplier", "CH4_multiplier"))
}
\seealso{
Other iotables processing functions: 
\code{\link{conforming_vector_create}()},
\code{\link{empty_remove}()},
\code{\link{household_column_find}()},
\code{\link{household_column_get}()},
\code{\link{iotable_year_get}()},
\code{\link{matrix_round}()},
\code{\link{output_get}()},
\code{\link{primary_input_get}()},
\code{\link{rows_add}()},
\code{\link{supplementary_add}()},
\code{\link{total_tax_add}()},
\code{\link{vector_transpose_longer}()},
\code{\link{vector_transpose_wider}()}
}
\concept{iotables processing functions}
