% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arpa.R
\name{arpa}
\alias{arpa}
\alias{arpabet}
\alias{cmu}
\title{Convert phonetic representation from ARPABET (CMU)}
\usage{
arpa(x, to = c("ipa", "xsampa"))

arpabet(x, to = c("ipa", "xsampa"))

cmu(x, to = c("ipa", "xsampa"))
}
\arguments{
\item{x}{A phonetic character vector in ARPABET}

\item{to}{The phonetic alphabet to convert to.
Defaults to \code{"ipa"}.
\code{"sampa"} is an accepted alias for \code{"xsampa"}.}
}
\value{
A character vector the same length as \code{x}
}
\description{
Converts to IPA or X-SAMPA
}
\examples{
arpa('HH EH L OW')
arpa(c('HH EH L OW', "W ER L D"))

arpa('HH EH L OW', "xsampa")
arpa(c('HH EH L OW', "W ER L D"), "xsampa")
}
\seealso{
\code{\link[=convert_phonetics]{convert_phonetics()}} to convert between any phonetic
representations

\code{\link[=ipa]{ipa()}} to convert from IPA

\code{\link[=sampa]{sampa()}} and \code{\link[=xsampa]{xsampa()}} to convert from X-SAMPA
}
