% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Accessor_functions.R
\name{Accessors}
\alias{Accessors}
\alias{get_intercept}
\alias{get_y}
\alias{get_size}
\alias{get_hyp}
\alias{get_lambda}
\alias{get_psi}
\alias{get_lengthscale}
\alias{get_hurst}
\alias{get_offset}
\alias{get_degree}
\alias{get_se}
\alias{get_kernels}
\alias{get_kern_matrix}
\alias{get_prederror}
\alias{get_estl}
\alias{get_method}
\alias{get_convergence}
\alias{get_niter}
\alias{get_time}
\alias{get_theta}
\title{Accessor functions for \code{ipriorMod} objects.}
\usage{
get_intercept(object)

get_y(object)

get_size(object, units = "kB", standard = "SI")

get_hyp(object)

get_lambda(object)

get_psi(object)

get_lengthscale(object)

get_hurst(object)

get_offset(object)

get_degree(object)

get_se(object)

get_kernels(object)

get_kern_matrix(object, theta = NULL, newdata)

get_prederror(object, error.type = c("RMSE", "MSE"))

get_estl(object)

get_method(object)

get_convergence(object)

get_niter(object)

get_time(object)

get_theta(object)
}
\arguments{
\item{object}{An \code{ipriorMod} object.}

\item{units}{Units for object size.}

\item{standard}{Standard for object size.}

\item{theta}{(Optional) Value of hyperparameters to evaluate the kernel
matrix.}

\item{newdata}{(Optional) If not supplied, then a square, symmetric kernel
matrix is returned using the data as input points. Otherwise, the kernel
matrix is evaluated with respect to this set of data as well. It must be a
list of vectors/matrices with similar dimensions to the original data.}

\item{error.type}{(Optional) Report the mean squared error of prediction
(\code{"MSE"}), or the root mean squared error of prediction
(\code{"RMSE"})}
}
\description{
Accessor functions for \code{ipriorMod} objects.
}
\section{Functions}{
\itemize{
\item \code{get_intercept()}: Obtain the intercept.

\item \code{get_y()}: Obtain the response variables.

\item \code{get_size()}: Obtain the object size of the I-prior model.

\item \code{get_hyp()}: Obtain the hyerparameters of the model (both estimated and fixed ones).

\item \code{get_lambda()}: Obtain the scale parameters used.

\item \code{get_psi()}: Obtain the error precision.

\item \code{get_lengthscale()}: Obtain the lengthscale for the SE kernels used.

\item \code{get_hurst()}: Obtain the Hurst coefficient of the fBm kernels used.

\item \code{get_offset()}: Obtain the offset parameters for the polynomial kernels used.

\item \code{get_degree()}: Obtain the degree of the polynomial kernels used.

\item \code{get_se()}: Obtain the standard errors of the estimated hyperparameters.

\item \code{get_kernels()}: Obtain the kernels used.

\item \code{get_kern_matrix()}: Obtain the kernel matrix of the I-prior model.

\item \code{get_prederror()}: Obtain the training mean squared error.

\item \code{get_estl()}: Obtain information on which hyperparameters were
estimated and which were fixed.

\item \code{get_method()}: Obtain the estimation method used.

\item \code{get_convergence()}: Obtain the convergence information.

\item \code{get_niter()}: Obtain the number of iterations performed.

\item \code{get_time()}: Obtain the time taken to complete the estimation
procedure.

\item \code{get_theta()}: Extract the theta value at convergence. Note that this
is on an unrestricted scale (see the vignette for details).

}}
